ALTER TABLE ADRREF.TABLEMANAGER
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.TABLEMANAGER CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.TABLEMANAGER
(
  ID             NUMBER(20)                     NOT NULL,
  TABLENAME      VARCHAR2(31 BYTE)              NOT NULL,
  RELEASENUMBER  VARCHAR2(5 BYTE)               NOT NULL,
  RELEASEDATE    VARCHAR2(15 BYTE),
  LASTPOPULATED  VARCHAR2(15 BYTE),
  LASTUPDATED    TIMESTAMP(6)                   NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.TABLEMANAGER.ID IS 'Unique Primary Key ID';

COMMENT ON COLUMN ADRREF.TABLEMANAGER.TABLENAME IS 'Table name to be tracked when changes';

COMMENT ON COLUMN ADRREF.TABLEMANAGER.RELEASENUMBER IS 'Release number was first loaded';

COMMENT ON COLUMN ADRREF.TABLEMANAGER.RELEASEDATE IS 'Release date was first loaded';

COMMENT ON COLUMN ADRREF.TABLEMANAGER.LASTPOPULATED IS 'Last populated data';

COMMENT ON COLUMN ADRREF.TABLEMANAGER.LASTUPDATED IS 'Last updated date';



CREATE UNIQUE INDEX ADRREF.TABLEMANAGER_ID_PK ON ADRREF.TABLEMANAGER
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.TABLEMANAGER_TABLENAME_I ON ADRREF.TABLEMANAGER
(TABLENAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM TABLEMANAGER FOR ADRREF.TABLEMANAGER;


ALTER TABLE ADRREF.TABLEMANAGER ADD (
  CONSTRAINT TABLEMANAGER_ID_PK
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.TABLEMANAGER_ID_PK
  ENABLE VALIDATE,
  CONSTRAINT TABLEMANAGER_TABLENAME_I
  UNIQUE (TABLENAME)
  USING INDEX ADRREF.TABLEMANAGER_TABLENAME_I
  ENABLE VALIDATE);

GRANT SELECT ON ADRREF.TABLEMANAGER TO ADR;

GRANT SELECT ON ADRREF.TABLEMANAGER TO ADREXT;

GRANT SELECT ON ADRREF.TABLEMANAGER TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.TABLEMANAGER TO ADRREF_RW;

GRANT SELECT ON ADRREF.TABLEMANAGER TO EEUSR;

GRANT SELECT ON ADRREF.TABLEMANAGER TO PSIM;
ALTER TABLE ADRREF.STD_WORKFLOWUPDATETYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_WORKFLOWUPDATETYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_WORKFLOWUPDATETYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(2 BYTE)                 NOT NULL,
  NAME         VARCHAR2(50 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_WORKFLOWUPDATETYPE.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWUPDATETYPE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWUPDATETYPE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWUPDATETYPE.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWUPDATETYPE.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_WKFLOUPDATETYPE ON ADRREF.STD_WORKFLOWUPDATETYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_WKFLOUPDATETYPECODE ON ADRREF.STD_WORKFLOWUPDATETYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_WKFLOUPDATETYPENAME ON ADRREF.STD_WORKFLOWUPDATETYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_WORKFLOWUPDA268_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_WORKFLOWUPDATETYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_WORKFLOWUPDATETYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_WORKFLOWUPDATETYPE FOR ADRREF.STD_WORKFLOWUPDATETYPE;


ALTER TABLE ADRREF.STD_WORKFLOWUPDATETYPE ADD (
  CONSTRAINT PK_STD_WKFLOUPDATETYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_WKFLOUPDATETYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_WKFLOUPDATETYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_WKFLOUPDATETYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_WKFLOUPDATETYPENAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_WKFLOUPDATETYPENAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_WORKFLOWUPDATETYPE TO ADR;

GRANT SELECT ON ADRREF.STD_WORKFLOWUPDATETYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_WORKFLOWUPDATETYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WORKFLOWUPDATETYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_WORKFLOWUPDATETYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_WORKFLOWUPDATETYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_WORKFLOWUPDATETYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_WORKFLOWUPDATETYPE TO PSIM;
ALTER TABLE ADRREF.STD_WORKFLOWCASETYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_WORKFLOWCASETYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_WORKFLOWCASETYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(3 BYTE)                 NOT NULL,
  NAME         VARCHAR2(60 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_WORKFLOWCASETYPE IS 'LOOKUP TABLE';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWCASETYPE.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWCASETYPE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWCASETYPE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWCASETYPE.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWCASETYPE.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_WKFLOCASETYPE ON ADRREF.STD_WORKFLOWCASETYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_WKFLOCASETYPECODE ON ADRREF.STD_WORKFLOWCASETYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_WKFLOCASETYPENAME ON ADRREF.STD_WORKFLOWCASETYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_WORKFLOWCASE159_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_WORKFLOWCASETYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_WORKFLOWCASETYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_WORKFLOWCASETYPE FOR ADRREF.STD_WORKFLOWCASETYPE;


ALTER TABLE ADRREF.STD_WORKFLOWCASETYPE ADD (
  CONSTRAINT PK_STD_WKFLOCASETYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_WKFLOCASETYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_WKFLOCASETYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_WKFLOCASETYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_WKFLOCASETYPENAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_WKFLOCASETYPENAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_WORKFLOWCASETYPE TO ADR;

GRANT SELECT ON ADRREF.STD_WORKFLOWCASETYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_WORKFLOWCASETYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WORKFLOWCASETYPE TO ADRREF_RW;

GRANT SELECT ON ADRREF.STD_WORKFLOWCASETYPE TO BIZFLOW_R;

GRANT REFERENCES, SELECT ON ADRREF.STD_WORKFLOWCASETYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_WORKFLOWCASETYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_WORKFLOWCASETYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_WORKFLOWCASETYPE TO PSIM;
ALTER TABLE ADRREF.STD_WORKFLOWCASESTATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_WORKFLOWCASESTATUS CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_WORKFLOWCASESTATUS
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(2 BYTE)                 NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_WORKFLOWCASESTATUS IS 'LOOKUP TABLE';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWCASESTATUS.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWCASESTATUS.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWCASESTATUS.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWCASESTATUS.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWCASESTATUS.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_WKFLOCASESTATUS ON ADRREF.STD_WORKFLOWCASESTATUS
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_WKFLOCASESTATUSCODE ON ADRREF.STD_WORKFLOWCASESTATUS
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_WKFLOCASESTATUSNAME ON ADRREF.STD_WORKFLOWCASESTATUS
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_WORKFLOWCASE122_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_WORKFLOWCASESTATUS
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_WORKFLOWCASESTATUS';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_WORKFLOWCASESTATUS FOR ADRREF.STD_WORKFLOWCASESTATUS;


ALTER TABLE ADRREF.STD_WORKFLOWCASESTATUS ADD (
  CONSTRAINT PK_STD_WKFLOCASESTATUS
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_WKFLOCASESTATUS
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_WKFLOCASESTATUSCODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_WKFLOCASESTATUSCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_WKFLOCASESTATUSNAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_WKFLOCASESTATUSNAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_WORKFLOWCASESTATUS TO ADR;

GRANT SELECT ON ADRREF.STD_WORKFLOWCASESTATUS TO ADREXT;

GRANT SELECT ON ADRREF.STD_WORKFLOWCASESTATUS TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WORKFLOWCASESTATUS TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_WORKFLOWCASESTATUS TO EESRV;

GRANT SELECT ON ADRREF.STD_WORKFLOWCASESTATUS TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_WORKFLOWCASESTATUS TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_WORKFLOWCASESTATUS TO PSIM;
ALTER TABLE ADRREF.STD_WORKFLOWCASEREQUEST
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_WORKFLOWCASEREQUEST CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_WORKFLOWCASEREQUEST
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(2 BYTE)                 NOT NULL,
  NAME         VARCHAR2(100 BYTE)               NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_WORKFLOWCASEREQUEST IS 'LOOKUP TABLE';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWCASEREQUEST.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWCASEREQUEST.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWCASEREQUEST.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWCASEREQUEST.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWCASEREQUEST.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_WKFLOCASEREQUEST ON ADRREF.STD_WORKFLOWCASEREQUEST
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_WKFLOCASEREQUESTCODE ON ADRREF.STD_WORKFLOWCASEREQUEST
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_WKFLOCASEREQUESTNAME ON ADRREF.STD_WORKFLOWCASEREQUEST
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_WORKFLOWCASE919_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_WORKFLOWCASEREQUEST
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_WORKFLOWCASEREQUEST';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_WORKFLOWCASEREQUEST FOR ADRREF.STD_WORKFLOWCASEREQUEST;


ALTER TABLE ADRREF.STD_WORKFLOWCASEREQUEST ADD (
  CONSTRAINT PK_STD_WKFLOCASEREQUEST
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_WKFLOCASEREQUEST
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_WKFLOCASEREQUESTCODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_WKFLOCASEREQUESTCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_WKFLOCASEREQUESTNAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_WKFLOCASEREQUESTNAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_WORKFLOWCASEREQUEST TO ADR;

GRANT SELECT ON ADRREF.STD_WORKFLOWCASEREQUEST TO ADREXT;

GRANT SELECT ON ADRREF.STD_WORKFLOWCASEREQUEST TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WORKFLOWCASEREQUEST TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_WORKFLOWCASEREQUEST TO EESRV;

GRANT SELECT ON ADRREF.STD_WORKFLOWCASEREQUEST TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_WORKFLOWCASEREQUEST TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_WORKFLOWCASEREQUEST TO PSIM;
ALTER TABLE ADRREF.STD_WORKFLOWCASEACTIVITY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_WORKFLOWCASEACTIVITY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_WORKFLOWCASEACTIVITY
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(2 BYTE)                 NOT NULL,
  NAME         VARCHAR2(50 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_WORKFLOWCASEACTIVITY IS 'LOOKUP TABLE';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWCASEACTIVITY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWCASEACTIVITY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWCASEACTIVITY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWCASEACTIVITY.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_WORKFLOWCASEACTIVITY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_WKFLOCASEACTIVITY ON ADRREF.STD_WORKFLOWCASEACTIVITY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_WKFLOCASEACTIVITYCODE ON ADRREF.STD_WORKFLOWCASEACTIVITY
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_WKFLOCASEACTIVITYNAME ON ADRREF.STD_WORKFLOWCASEACTIVITY
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_WORKFLOWCASE169_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_WORKFLOWCASEACTIVITY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_WORKFLOWCASEACTIVITY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_WORKFLOWCASEACTIVITY FOR ADRREF.STD_WORKFLOWCASEACTIVITY;


ALTER TABLE ADRREF.STD_WORKFLOWCASEACTIVITY ADD (
  CONSTRAINT PK_STD_WKFLOCASEACTIVITY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_WKFLOCASEACTIVITY
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_WKFLOCASEACTIVITYCODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_WKFLOCASEACTIVITYCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_WKFLOCASEACTIVITYNAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_WKFLOCASEACTIVITYNAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_WORKFLOWCASEACTIVITY TO ADR;

GRANT SELECT ON ADRREF.STD_WORKFLOWCASEACTIVITY TO ADREXT;

GRANT SELECT ON ADRREF.STD_WORKFLOWCASEACTIVITY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WORKFLOWCASEACTIVITY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_WORKFLOWCASEACTIVITY TO EESRV;

GRANT SELECT ON ADRREF.STD_WORKFLOWCASEACTIVITY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_WORKFLOWCASEACTIVITY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_WORKFLOWCASEACTIVITY TO PSIM;
ALTER TABLE ADRREF.STD_WKFLOUPDATETYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_WKFLOUPDATETYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_WKFLOUPDATETYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_WKFLOUPDATETYPEHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_WKFLOUPDATETYPEHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_WKFLOUPDATETYPEHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_WKFLOUPDATETYPEHISTORY.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_WKFLOUPDATETYPEHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_WKFLOUPDATETYPEHISTORY ON ADRREF.STD_WKFLOUPDATETYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_WKFLOUPDATET723_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_WKFLOUPDATETYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_WKFLOUPDATETYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_WKFLOUPDATETYPEHISTORY FOR ADRREF.STD_WKFLOUPDATETYPEHISTORY;


ALTER TABLE ADRREF.STD_WKFLOUPDATETYPEHISTORY ADD (
  CONSTRAINT PK_STD_WKFLOUPDATETYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_WKFLOUPDATETYPEHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_WKFLOUPDATETYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_WKFLOUPDATETYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_WKFLOUPDATETYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WKFLOUPDATETYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_WKFLOUPDATETYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_WKFLOUPDATETYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_WKFLOUPDATETYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_WKFLOUPDATETYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_WKFLOCASETYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_WKFLOCASETYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_WKFLOCASETYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_WKFLOCASETYPEHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_WKFLOCASETYPEHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_WKFLOCASETYPEHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_WKFLOCASETYPEHISTORY.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_WKFLOCASETYPEHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_WKFLOCASETYPEHISTORY ON ADRREF.STD_WKFLOCASETYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_WKFLOCASETYP171_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_WKFLOCASETYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_WKFLOCASETYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_WKFLOCASETYPEHISTORY FOR ADRREF.STD_WKFLOCASETYPEHISTORY;


ALTER TABLE ADRREF.STD_WKFLOCASETYPEHISTORY ADD (
  CONSTRAINT PK_STD_WKFLOCASETYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_WKFLOCASETYPEHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_WKFLOCASETYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_WKFLOCASETYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_WKFLOCASETYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WKFLOCASETYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_WKFLOCASETYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_WKFLOCASETYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_WKFLOCASETYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_WKFLOCASETYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_WKFLOCASESTATUSHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_WKFLOCASESTATUSHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_WKFLOCASESTATUSHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_WKFLOCASESTATUSHISTORY ON ADRREF.STD_WKFLOCASESTATUSHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_WKFLOCASESTA188_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_WKFLOCASESTATUSHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_WKFLOCASESTATUSHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_WKFLOCASESTATUSHISTORY FOR ADRREF.STD_WKFLOCASESTATUSHISTORY;


ALTER TABLE ADRREF.STD_WKFLOCASESTATUSHISTORY ADD (
  CONSTRAINT PK_STD_WKFLOCASESTATUSHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_WKFLOCASESTATUSHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_WKFLOCASESTATUSHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_WKFLOCASESTATUSHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_WKFLOCASESTATUSHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WKFLOCASESTATUSHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_WKFLOCASESTATUSHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_WKFLOCASESTATUSHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_WKFLOCASESTATUSHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_WKFLOCASESTATUSHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_WKFLOCASEREQUESTHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_WKFLOCASEREQUESTHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_WKFLOCASEREQUESTHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_WKFLOCASEREQUESTHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_WKFLOCASEREQUESTHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_WKFLOCASEREQUESTHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_WKFLOCASEREQUESTHISTORY.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_WKFLOCASEREQUESTHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_WKFLOCASEREQUESTHISTORY ON ADRREF.STD_WKFLOCASEREQUESTHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_WKFLOCASEREQ122_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_WKFLOCASEREQUESTHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_WKFLOCASEREQUESTHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_WKFLOCASEREQUESTHISTORY FOR ADRREF.STD_WKFLOCASEREQUESTHISTORY;


ALTER TABLE ADRREF.STD_WKFLOCASEREQUESTHISTORY ADD (
  CONSTRAINT PK_STD_WKFLOCASEREQUESTHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_WKFLOCASEREQUESTHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_WKFLOCASEREQUESTHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_WKFLOCASEREQUESTHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_WKFLOCASEREQUESTHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WKFLOCASEREQUESTHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_WKFLOCASEREQUESTHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_WKFLOCASEREQUESTHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_WKFLOCASEREQUESTHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_WKFLOCASEREQUESTHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_WKFLOCASEACTIVITYHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_WKFLOCASEACTIVITYHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_WKFLOCASEACTIVITYHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_WKFLOCASEACTIVITYHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_WKFLOCASEACTIVITYHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_WKFLOCASEACTIVITYHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_WKFLOCASEACTIVITYHISTORY.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_WKFLOCASEACTIVITYHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_WKFLOCASEACTIVITYHSTRY ON ADRREF.STD_WKFLOCASEACTIVITYHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_WKFLOCASEACT724_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_WKFLOCASEACTIVITYHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_WKFLOCASEACTIVITYHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_WKFLOCASEACTIVITYHISTORY FOR ADRREF.STD_WKFLOCASEACTIVITYHISTORY;


ALTER TABLE ADRREF.STD_WKFLOCASEACTIVITYHISTORY ADD (
  CONSTRAINT PK_STD_WKFLOCASEACTIVITYHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_WKFLOCASEACTIVITYHSTRY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_WKFLOCASEACTIVITYHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_WKFLOCASEACTIVITYHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_WKFLOCASEACTIVITYHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WKFLOCASEACTIVITYHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_WKFLOCASEACTIVITYHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_WKFLOCASEACTIVITYHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_WKFLOCASEACTIVITYHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_WKFLOCASEACTIVITYHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_WKFISSUETYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_WKFISSUETYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_WKFISSUETYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_WKFISSUETYPEHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_WKFISSUETYPEHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_WKFISSUETYPEHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_WKFISSUETYPEHISTORY.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_WKFISSUETYPEHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_WKFISSUETYPEHISTORY ON ADRREF.STD_WKFISSUETYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_WKFISSUETYPE131_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_WKFISSUETYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_WKFISSUETYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_WKFISSUETYPEHISTORY FOR ADRREF.STD_WKFISSUETYPEHISTORY;


ALTER TABLE ADRREF.STD_WKFISSUETYPEHISTORY ADD (
  CONSTRAINT PK_STD_WKFISSUETYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_WKFISSUETYPEHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_WKFISSUETYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_WKFISSUETYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_WKFISSUETYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WKFISSUETYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_WKFISSUETYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_WKFISSUETYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_WKFISSUETYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_WKFISSUETYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_WKFISSUETYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_WKFISSUETYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_WKFISSUETYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(4 BYTE)                 NOT NULL,
  NAME         VARCHAR2(120 BYTE)               NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_WKFISSUETYPE ON ADRREF.STD_WKFISSUETYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_WKFISSUETYPECODE ON ADRREF.STD_WKFISSUETYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_WKFISSUETYPENAME ON ADRREF.STD_WKFISSUETYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_WKFISSUETYPE_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_WKFISSUETYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_WKFISSUETYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_WKFISSUETYPE FOR ADRREF.STD_WKFISSUETYPE;


ALTER TABLE ADRREF.STD_WKFISSUETYPE ADD (
  CONSTRAINT PK_STD_WKFISSUETYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_WKFISSUETYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_WKFISSUETYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_WKFISSUETYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_WKFISSUETYPENAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_WKFISSUETYPENAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_WKFISSUETYPE TO ADR;

GRANT SELECT ON ADRREF.STD_WKFISSUETYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_WKFISSUETYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WKFISSUETYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_WKFISSUETYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_WKFISSUETYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_WKFISSUETYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_WKFISSUETYPE TO PSIM;
ALTER TABLE ADRREF.STD_WKFDATAJOBSTATUSHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_WKFDATAJOBSTATUSHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_WKFDATAJOBSTATUSHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_WKFDATAJOBSTATUSHISTORY ON ADRREF.STD_WKFDATAJOBSTATUSHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_WKFDATAJOBST421_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_WKFDATAJOBSTATUSHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_WKFDATAJOBSTATUSHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_WKFDATAJOBSTATUSHISTORY FOR ADRREF.STD_WKFDATAJOBSTATUSHISTORY;


ALTER TABLE ADRREF.STD_WKFDATAJOBSTATUSHISTORY ADD (
  CONSTRAINT PK_STD_WKFDATAJOBSTATUSHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_WKFDATAJOBSTATUSHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_WKFDATAJOBSTATUSHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_WKFDATAJOBSTATUSHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_WKFDATAJOBSTATUSHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WKFDATAJOBSTATUSHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_WKFDATAJOBSTATUSHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_WKFDATAJOBSTATUSHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_WKFDATAJOBSTATUSHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_WKFDATAJOBSTATUSHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_WKFDATAJOBSTATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_WKFDATAJOBSTATUS CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_WKFDATAJOBSTATUS
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(3 BYTE)                 NOT NULL,
  NAME         VARCHAR2(80 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_WKFDATAJOBSTATUS ON ADRREF.STD_WKFDATAJOBSTATUS
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_WKFDATAJOBSTATUSCODE ON ADRREF.STD_WKFDATAJOBSTATUS
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_WKFDATAJOBSTATUSNAME ON ADRREF.STD_WKFDATAJOBSTATUS
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_WKFDATAJOBST360_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_WKFDATAJOBSTATUS
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_WKFDATAJOBSTATUS';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_WKFDATAJOBSTATUS FOR ADRREF.STD_WKFDATAJOBSTATUS;


ALTER TABLE ADRREF.STD_WKFDATAJOBSTATUS ADD (
  CONSTRAINT PK_STD_WKFDATAJOBSTATUS
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_WKFDATAJOBSTATUS
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_WKFDATAJOBSTATUSCODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_WKFDATAJOBSTATUSCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_WKFDATAJOBSTATUSNAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_WKFDATAJOBSTATUSNAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_WKFDATAJOBSTATUS TO ADR;

GRANT SELECT ON ADRREF.STD_WKFDATAJOBSTATUS TO ADREXT;

GRANT SELECT ON ADRREF.STD_WKFDATAJOBSTATUS TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WKFDATAJOBSTATUS TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_WKFDATAJOBSTATUS TO EESRV;

GRANT SELECT ON ADRREF.STD_WKFDATAJOBSTATUS TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_WKFDATAJOBSTATUS TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_WKFDATAJOBSTATUS TO PSIM;
ALTER TABLE ADRREF.STD_WKFDATAJOBACTIONHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_WKFDATAJOBACTIONHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_WKFDATAJOBACTIONHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_WKFDATAJOBACTIONHISTORY ON ADRREF.STD_WKFDATAJOBACTIONHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_WKFDATAJOBAC124_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_WKFDATAJOBACTIONHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_WKFDATAJOBACTIONHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_WKFDATAJOBACTIONHISTORY FOR ADRREF.STD_WKFDATAJOBACTIONHISTORY;


ALTER TABLE ADRREF.STD_WKFDATAJOBACTIONHISTORY ADD (
  CONSTRAINT PK_STD_WKFDATAJOBACTIONHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_WKFDATAJOBACTIONHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_WKFDATAJOBACTIONHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_WKFDATAJOBACTIONHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_WKFDATAJOBACTIONHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WKFDATAJOBACTIONHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_WKFDATAJOBACTIONHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_WKFDATAJOBACTIONHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_WKFDATAJOBACTIONHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_WKFDATAJOBACTIONHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_WKFDATAJOBACTION
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_WKFDATAJOBACTION CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_WKFDATAJOBACTION
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(3 BYTE)                 NOT NULL,
  NAME         VARCHAR2(80 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_WKFDATAJOBACTION ON ADRREF.STD_WKFDATAJOBACTION
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_WKFDATAJOBACTIONCODE ON ADRREF.STD_WKFDATAJOBACTION
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_WKFDATAJOBACTIONNAME ON ADRREF.STD_WKFDATAJOBACTION
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_WKFDATAJOBAC110_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_WKFDATAJOBACTION
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_WKFDATAJOBACTION';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_WKFDATAJOBACTION FOR ADRREF.STD_WKFDATAJOBACTION;


ALTER TABLE ADRREF.STD_WKFDATAJOBACTION ADD (
  CONSTRAINT PK_STD_WKFDATAJOBACTION
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_WKFDATAJOBACTION
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_WKFDATAJOBACTIONCODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_WKFDATAJOBACTIONCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_WKFDATAJOBACTIONNAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_WKFDATAJOBACTIONNAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_WKFDATAJOBACTION TO ADR;

GRANT SELECT ON ADRREF.STD_WKFDATAJOBACTION TO ADREXT;

GRANT SELECT ON ADRREF.STD_WKFDATAJOBACTION TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_WKFDATAJOBACTION TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_WKFDATAJOBACTION TO EESRV;

GRANT SELECT ON ADRREF.STD_WKFDATAJOBACTION TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_WKFDATAJOBACTION TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_WKFDATAJOBACTION TO PSIM;
ALTER TABLE ADRREF.STD_USERABSENCETYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_USERABSENCETYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_USERABSENCETYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_USERABSENCETYPEHISTORY ON ADRREF.STD_USERABSENCETYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_USERABSENCET644_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_USERABSENCETYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_USERABSENCETYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_USERABSENCETYPEHISTORY FOR ADRREF.STD_USERABSENCETYPEHISTORY;


ALTER TABLE ADRREF.STD_USERABSENCETYPEHISTORY ADD (
  CONSTRAINT PK_STD_USERABSENCETYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_USERABSENCETYPEHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_USERABSENCETYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_USERABSENCETYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_USERABSENCETYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_USERABSENCETYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_USERABSENCETYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_USERABSENCETYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_USERABSENCETYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_USERABSENCETYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_USERABSENCETYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_USERABSENCETYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_USERABSENCETYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(3 BYTE)                 NOT NULL,
  NAME         VARCHAR2(80 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_USERABSENCETYPE ON ADRREF.STD_USERABSENCETYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_USERABSENCETYPECODE ON ADRREF.STD_USERABSENCETYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_USERABSENCETYPENAME ON ADRREF.STD_USERABSENCETYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_USERABSENCET867_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_USERABSENCETYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_USERABSENCETYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_USERABSENCETYPE FOR ADRREF.STD_USERABSENCETYPE;


ALTER TABLE ADRREF.STD_USERABSENCETYPE ADD (
  CONSTRAINT PK_STD_USERABSENCETYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_USERABSENCETYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_USERABSENCETYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_USERABSENCETYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_USERABSENCETYPENAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_USERABSENCETYPENAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_USERABSENCETYPE TO ADR;

GRANT SELECT ON ADRREF.STD_USERABSENCETYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_USERABSENCETYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_USERABSENCETYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_USERABSENCETYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_USERABSENCETYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_USERABSENCETYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_USERABSENCETYPE TO PSIM;
ALTER TABLE ADRREF.STD_RPTWORKITEMSTTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTWORKITEMSTTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTWORKITEMSTTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTWORKITEMSTTYPEHSTRY ON ADRREF.STD_RPTWORKITEMSTTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTWORKITEMS107_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTWORKITEMSTTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTWORKITEMSTTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTWORKITEMSTTYPEHISTORY FOR ADRREF.STD_RPTWORKITEMSTTYPEHISTORY;


ALTER TABLE ADRREF.STD_RPTWORKITEMSTTYPEHISTORY ADD (
  CONSTRAINT PK_STD_RPTWORKITEMSTTYPEHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTWORKITEMSTTYPEHSTRY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTWORKITEMSTTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_RPTWORKITEMSTTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTWORKITEMSTTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTWORKITEMSTTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTWORKITEMSTTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTWORKITEMSTTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTWORKITEMSTTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTWORKITEMSTTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_RPTWORKITEMSTTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTWORKITEMSTTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTWORKITEMSTTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(40 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTWORKITEMSTTYPE ON ADRREF.STD_RPTWORKITEMSTTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_RPTWORKITEMSTTYPECODE ON ADRREF.STD_RPTWORKITEMSTTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_RPTWORKITEMSTTYPENAME ON ADRREF.STD_RPTWORKITEMSTTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTWORKITEMS147_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTWORKITEMSTTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTWORKITEMSTTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTWORKITEMSTTYPE FOR ADRREF.STD_RPTWORKITEMSTTYPE;


ALTER TABLE ADRREF.STD_RPTWORKITEMSTTYPE ADD (
  CONSTRAINT PK_STD_RPTWORKITEMSTTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTWORKITEMSTTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RPTWORKITEMSTTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_RPTWORKITEMSTTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RPTWORKITEMSTTYPENAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_RPTWORKITEMSTTYPENAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTWORKITEMSTTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_RPTWORKITEMSTTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTWORKITEMSTTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTWORKITEMSTTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTWORKITEMSTTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTWORKITEMSTTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTWORKITEMSTTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTWORKITEMSTTYPE TO PSIM;
ALTER TABLE ADRREF.STD_RPTWEEKOFMONTHTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTWEEKOFMONTHTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTWEEKOFMONTHTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTWEEKOFMONTHTYPEHSTRY ON ADRREF.STD_RPTWEEKOFMONTHTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTWEEKOFMON162_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTWEEKOFMONTHTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTWEEKOFMONTHTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTWEEKOFMONTHTYPEHISTORY FOR ADRREF.STD_RPTWEEKOFMONTHTYPEHISTORY;


ALTER TABLE ADRREF.STD_RPTWEEKOFMONTHTYPEHISTORY ADD (
  CONSTRAINT PK_STD_RPTWEEKOFMONTHTYPEHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTWEEKOFMONTHTYPEHSTRY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTWEEKOFMONTHTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_RPTWEEKOFMONTHTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTWEEKOFMONTHTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTWEEKOFMONTHTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTWEEKOFMONTHTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTWEEKOFMONTHTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTWEEKOFMONTHTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTWEEKOFMONTHTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_RPTWEEKOFMONTHTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTWEEKOFMONTHTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTWEEKOFMONTHTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTWEEKOFMONTHTYPE ON ADRREF.STD_RPTWEEKOFMONTHTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_RPTWEEKOFMONTHTYPECODE ON ADRREF.STD_RPTWEEKOFMONTHTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTWEEKOFMON185_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTWEEKOFMONTHTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTWEEKOFMONTHTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTWEEKOFMONTHTYPE FOR ADRREF.STD_RPTWEEKOFMONTHTYPE;


ALTER TABLE ADRREF.STD_RPTWEEKOFMONTHTYPE ADD (
  CONSTRAINT PK_STD_RPTWEEKOFMONTHTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTWEEKOFMONTHTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RPTWEEKOFMONTHTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_RPTWEEKOFMONTHTYPECODE
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTWEEKOFMONTHTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_RPTWEEKOFMONTHTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTWEEKOFMONTHTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTWEEKOFMONTHTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTWEEKOFMONTHTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTWEEKOFMONTHTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTWEEKOFMONTHTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTWEEKOFMONTHTYPE TO PSIM;
ALTER TABLE ADRREF.STD_RPTSTATUSCOMPONENTHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTSTATUSCOMPONENTHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTSTATUSCOMPONENTHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTSTATUSCOMPONENTHSTRY ON ADRREF.STD_RPTSTATUSCOMPONENTHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTSTATUSCOM113_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTSTATUSCOMPONENTHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTSTATUSCOMPONENTHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTSTATUSCOMPONENTHISTORY FOR ADRREF.STD_RPTSTATUSCOMPONENTHISTORY;


ALTER TABLE ADRREF.STD_RPTSTATUSCOMPONENTHISTORY ADD (
  CONSTRAINT PK_STD_RPTSTATUSCOMPONENTHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTSTATUSCOMPONENTHSTRY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTSTATUSCOMPONENTHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_RPTSTATUSCOMPONENTHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTSTATUSCOMPONENTHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTSTATUSCOMPONENTHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTSTATUSCOMPONENTHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTSTATUSCOMPONENTHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTSTATUSCOMPONENTHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTSTATUSCOMPONENTHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_RPTSTATUSCOMPONENT
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTSTATUSCOMPONENT CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTSTATUSCOMPONENT
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(5 BYTE)                 NOT NULL,
  NAME         VARCHAR2(80 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTSTATUSCOMPONENT ON ADRREF.STD_RPTSTATUSCOMPONENT
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_RPTSTATUSCOMPONENTCODE ON ADRREF.STD_RPTSTATUSCOMPONENT
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_RPTSTATUSCOMPONENTNAME ON ADRREF.STD_RPTSTATUSCOMPONENT
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTSTATUSCOM155_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTSTATUSCOMPONENT
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTSTATUSCOMPONENT';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTSTATUSCOMPONENT FOR ADRREF.STD_RPTSTATUSCOMPONENT;


ALTER TABLE ADRREF.STD_RPTSTATUSCOMPONENT ADD (
  CONSTRAINT PK_STD_RPTSTATUSCOMPONENT
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTSTATUSCOMPONENT
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RPTSTATUSCOMPONENTCODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_RPTSTATUSCOMPONENTCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RPTSTATUSCOMPONENTNAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_RPTSTATUSCOMPONENTNAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTSTATUSCOMPONENT TO ADR;

GRANT SELECT ON ADRREF.STD_RPTSTATUSCOMPONENT TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTSTATUSCOMPONENT TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTSTATUSCOMPONENT TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTSTATUSCOMPONENT TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTSTATUSCOMPONENT TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTSTATUSCOMPONENT TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTSTATUSCOMPONENT TO PSIM;
ALTER TABLE ADRREF.STD_RPTSTANDARDREPORTSHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTSTANDARDREPORTSHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTSTANDARDREPORTSHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTSTANDARDREPORTSHSTRY ON ADRREF.STD_RPTSTANDARDREPORTSHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTSTANDARDR125_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTSTANDARDREPORTSHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTSTANDARDREPORTSHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTSTANDARDREPORTSHISTORY FOR ADRREF.STD_RPTSTANDARDREPORTSHISTORY;


ALTER TABLE ADRREF.STD_RPTSTANDARDREPORTSHISTORY ADD (
  CONSTRAINT PK_STD_RPTSTANDARDREPORTSHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTSTANDARDREPORTSHSTRY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTSTANDARDREPORTSHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_RPTSTANDARDREPORTSHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTSTANDARDREPORTSHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTSTANDARDREPORTSHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTSTANDARDREPORTSHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTSTANDARDREPORTSHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTSTANDARDREPORTSHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTSTANDARDREPORTSHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_RPTSTANDARDREPORTS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTSTANDARDREPORTS CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTSTANDARDREPORTS
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(10 BYTE)                NOT NULL,
  NAME         VARCHAR2(80 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  TYPE_ID      NUMBER(20)                       NOT NULL,
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTSTANDARDREPORTS ON ADRREF.STD_RPTSTANDARDREPORTS
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTSTANDARDR554_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTSTANDARDREPORTS
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTSTANDARDREPORTS';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTSTANDARDREPORTS FOR ADRREF.STD_RPTSTANDARDREPORTS;


ALTER TABLE ADRREF.STD_RPTSTANDARDREPORTS ADD (
  CONSTRAINT PK_STD_RPTSTANDARDREPORTS
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTSTANDARDREPORTS
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTSTANDARDREPORTS TO ADR;

GRANT SELECT ON ADRREF.STD_RPTSTANDARDREPORTS TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTSTANDARDREPORTS TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTSTANDARDREPORTS TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTSTANDARDREPORTS TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTSTANDARDREPORTS TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTSTANDARDREPORTS TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTSTANDARDREPORTS TO PSIM;
ALTER TABLE ADRREF.STD_RPTSITEDISPLAYTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTSITEDISPLAYTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTSITEDISPLAYTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_RPTSITEDISPLAYTYPEHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_RPTSITEDISPLAYTYPEHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_RPTSITEDISPLAYTYPEHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_RPTSITEDISPLAYTYPEHISTORY.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_RPTSITEDISPLAYTYPEHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_RPTSITEDISPLAYTYPEHSTRY ON ADRREF.STD_RPTSITEDISPLAYTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTSITEDISPL193_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTSITEDISPLAYTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTSITEDISPLAYTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTSITEDISPLAYTYPEHISTORY FOR ADRREF.STD_RPTSITEDISPLAYTYPEHISTORY;


ALTER TABLE ADRREF.STD_RPTSITEDISPLAYTYPEHISTORY ADD (
  CONSTRAINT PK_STD_RPTSITEDISPLAYTYPEHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTSITEDISPLAYTYPEHSTRY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTSITEDISPLAYTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_RPTSITEDISPLAYTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTSITEDISPLAYTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTSITEDISPLAYTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTSITEDISPLAYTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTSITEDISPLAYTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTSITEDISPLAYTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTSITEDISPLAYTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_RPTSITEDISPLAYTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTSITEDISPLAYTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTSITEDISPLAYTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTSITEDISPLAYTYPE ON ADRREF.STD_RPTSITEDISPLAYTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_RPTSITEDISPLAYTYPECODE ON ADRREF.STD_RPTSITEDISPLAYTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTSITEDISPL213_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTSITEDISPLAYTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTSITEDISPLAYTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTSITEDISPLAYTYPE FOR ADRREF.STD_RPTSITEDISPLAYTYPE;


ALTER TABLE ADRREF.STD_RPTSITEDISPLAYTYPE ADD (
  CONSTRAINT PK_STD_RPTSITEDISPLAYTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTSITEDISPLAYTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RPTSITEDISPLAYTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_RPTSITEDISPLAYTYPECODE
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTSITEDISPLAYTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_RPTSITEDISPLAYTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTSITEDISPLAYTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTSITEDISPLAYTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTSITEDISPLAYTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTSITEDISPLAYTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTSITEDISPLAYTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTSITEDISPLAYTYPE TO PSIM;
ALTER TABLE ADRREF.STD_RPTSCHEDULETYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTSCHEDULETYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTSCHEDULETYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTSCHEDULETYPEHISTORY ON ADRREF.STD_RPTSCHEDULETYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTSCHEDULET195_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTSCHEDULETYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTSCHEDULETYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTSCHEDULETYPEHISTORY FOR ADRREF.STD_RPTSCHEDULETYPEHISTORY;


ALTER TABLE ADRREF.STD_RPTSCHEDULETYPEHISTORY ADD (
  CONSTRAINT PK_STD_RPTSCHEDULETYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTSCHEDULETYPEHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTSCHEDULETYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_RPTSCHEDULETYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTSCHEDULETYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTSCHEDULETYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTSCHEDULETYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTSCHEDULETYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTSCHEDULETYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTSCHEDULETYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_RPTSCHEDULETYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTSCHEDULETYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTSCHEDULETYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTSCHEDULETYPE ON ADRREF.STD_RPTSCHEDULETYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_RPTSCHEDULETYPECODE ON ADRREF.STD_RPTSCHEDULETYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTSCHEDULET105_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTSCHEDULETYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTSCHEDULETYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTSCHEDULETYPE FOR ADRREF.STD_RPTSCHEDULETYPE;


ALTER TABLE ADRREF.STD_RPTSCHEDULETYPE ADD (
  CONSTRAINT PK_STD_RPTSCHEDULETYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTSCHEDULETYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RPTSCHEDULETYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_RPTSCHEDULETYPECODE
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTSCHEDULETYPE TO ADR;

GRANT SELECT ON ADRREF.STD_RPTSCHEDULETYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTSCHEDULETYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTSCHEDULETYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTSCHEDULETYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTSCHEDULETYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTSCHEDULETYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTSCHEDULETYPE TO PSIM;
ALTER TABLE ADRREF.STD_RPTRUNFREQUENCYTYPHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTRUNFREQUENCYTYPHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTRUNFREQUENCYTYPHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTRUNFREQUENCYTYPHSTRY ON ADRREF.STD_RPTRUNFREQUENCYTYPHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTRUNFREQUE196_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTRUNFREQUENCYTYPHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTRUNFREQUENCYTYPHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTRUNFREQUENCYTYPHISTORY FOR ADRREF.STD_RPTRUNFREQUENCYTYPHISTORY;


ALTER TABLE ADRREF.STD_RPTRUNFREQUENCYTYPHISTORY ADD (
  CONSTRAINT PK_STD_RPTRUNFREQUENCYTYPHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTRUNFREQUENCYTYPHSTRY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTRUNFREQUENCYTYPHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_RPTRUNFREQUENCYTYPHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTRUNFREQUENCYTYPHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTRUNFREQUENCYTYPHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTRUNFREQUENCYTYPHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTRUNFREQUENCYTYPHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTRUNFREQUENCYTYPHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTRUNFREQUENCYTYPHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_RPTRUNFREQUENCYTYP
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTRUNFREQUENCYTYP CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTRUNFREQUENCYTYP
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTRUNFREQUENCYTYP ON ADRREF.STD_RPTRUNFREQUENCYTYP
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_RPTRUNFREQUENCYTYPCODE ON ADRREF.STD_RPTRUNFREQUENCYTYP
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTRUNFREQUE198_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTRUNFREQUENCYTYP
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTRUNFREQUENCYTYP';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTRUNFREQUENCYTYP FOR ADRREF.STD_RPTRUNFREQUENCYTYP;


ALTER TABLE ADRREF.STD_RPTRUNFREQUENCYTYP ADD (
  CONSTRAINT PK_STD_RPTRUNFREQUENCYTYP
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTRUNFREQUENCYTYP
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RPTRUNFREQUENCYTYPCODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_RPTRUNFREQUENCYTYPCODE
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTRUNFREQUENCYTYP TO ADR;

GRANT SELECT ON ADRREF.STD_RPTRUNFREQUENCYTYP TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTRUNFREQUENCYTYP TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTRUNFREQUENCYTYP TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTRUNFREQUENCYTYP TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTRUNFREQUENCYTYP TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTRUNFREQUENCYTYP TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTRUNFREQUENCYTYP TO PSIM;
ALTER TABLE ADRREF.STD_RPTQUARTERLISTHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTQUARTERLISTHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTQUARTERLISTHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTQUARTERLISTHISTORY ON ADRREF.STD_RPTQUARTERLISTHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTQUARTERLI412_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTQUARTERLISTHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTQUARTERLISTHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTQUARTERLISTHISTORY FOR ADRREF.STD_RPTQUARTERLISTHISTORY;


ALTER TABLE ADRREF.STD_RPTQUARTERLISTHISTORY ADD (
  CONSTRAINT PK_STD_RPTQUARTERLISTHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTQUARTERLISTHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTQUARTERLISTHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_RPTQUARTERLISTHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTQUARTERLISTHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTQUARTERLISTHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTQUARTERLISTHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTQUARTERLISTHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTQUARTERLISTHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTQUARTERLISTHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_RPTQUARTERLIST
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTQUARTERLIST CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTQUARTERLIST
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTQUARTERLIST ON ADRREF.STD_RPTQUARTERLIST
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_RPTQUARTERLISTCODE ON ADRREF.STD_RPTQUARTERLIST
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTQUARTERLI398_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTQUARTERLIST
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTQUARTERLIST';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTQUARTERLIST FOR ADRREF.STD_RPTQUARTERLIST;


ALTER TABLE ADRREF.STD_RPTQUARTERLIST ADD (
  CONSTRAINT PK_STD_RPTQUARTERLIST
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTQUARTERLIST
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RPTQUARTERLISTCODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_RPTQUARTERLISTCODE
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTQUARTERLIST TO ADR;

GRANT SELECT ON ADRREF.STD_RPTQUARTERLIST TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTQUARTERLIST TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTQUARTERLIST TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTQUARTERLIST TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTQUARTERLIST TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTQUARTERLIST TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTQUARTERLIST TO PSIM;
ALTER TABLE ADRREF.STD_RPTPERIODTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTPERIODTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTPERIODTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTPERIODTYPEHISTORY ON ADRREF.STD_RPTPERIODTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTPERIODTYP163_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTPERIODTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTPERIODTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTPERIODTYPEHISTORY FOR ADRREF.STD_RPTPERIODTYPEHISTORY;


ALTER TABLE ADRREF.STD_RPTPERIODTYPEHISTORY ADD (
  CONSTRAINT PK_STD_RPTPERIODTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTPERIODTYPEHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTPERIODTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_RPTPERIODTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTPERIODTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTPERIODTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTPERIODTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTPERIODTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTPERIODTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTPERIODTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_RPTPERIODTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTPERIODTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTPERIODTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTPERIODTYPE ON ADRREF.STD_RPTPERIODTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_RPTPERIODTYPECODE ON ADRREF.STD_RPTPERIODTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTPERIODTYP134_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTPERIODTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTPERIODTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTPERIODTYPE FOR ADRREF.STD_RPTPERIODTYPE;


ALTER TABLE ADRREF.STD_RPTPERIODTYPE ADD (
  CONSTRAINT PK_STD_RPTPERIODTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTPERIODTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RPTPERIODTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_RPTPERIODTYPECODE
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTPERIODTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_RPTPERIODTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTPERIODTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTPERIODTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTPERIODTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTPERIODTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTPERIODTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTPERIODTYPE TO PSIM;
ALTER TABLE ADRREF.STD_RPTOUTPUTFILETYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTOUTPUTFILETYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTOUTPUTFILETYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTOUTPUTFILETYPEHSTRY ON ADRREF.STD_RPTOUTPUTFILETYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTOUTPUTFIL641_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTOUTPUTFILETYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTOUTPUTFILETYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTOUTPUTFILETYPEHISTORY FOR ADRREF.STD_RPTOUTPUTFILETYPEHISTORY;


ALTER TABLE ADRREF.STD_RPTOUTPUTFILETYPEHISTORY ADD (
  CONSTRAINT PK_STD_RPTOUTPUTFILETYPEHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTOUTPUTFILETYPEHSTRY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTOUTPUTFILETYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_RPTOUTPUTFILETYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTOUTPUTFILETYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTOUTPUTFILETYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTOUTPUTFILETYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTOUTPUTFILETYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTOUTPUTFILETYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTOUTPUTFILETYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_RPTOUTPUTFILETYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTOUTPUTFILETYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTOUTPUTFILETYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(3 BYTE)                 NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTOUTPUTFILETYPE ON ADRREF.STD_RPTOUTPUTFILETYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_RPTOUTPUTFILETYPECODE ON ADRREF.STD_RPTOUTPUTFILETYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTOUTPUTFIL201_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTOUTPUTFILETYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTOUTPUTFILETYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTOUTPUTFILETYPE FOR ADRREF.STD_RPTOUTPUTFILETYPE;


ALTER TABLE ADRREF.STD_RPTOUTPUTFILETYPE ADD (
  CONSTRAINT PK_STD_RPTOUTPUTFILETYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTOUTPUTFILETYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RPTOUTPUTFILETYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_RPTOUTPUTFILETYPECODE
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTOUTPUTFILETYPE TO ADR;

GRANT SELECT ON ADRREF.STD_RPTOUTPUTFILETYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTOUTPUTFILETYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTOUTPUTFILETYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTOUTPUTFILETYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTOUTPUTFILETYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTOUTPUTFILETYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTOUTPUTFILETYPE TO PSIM;
ALTER TABLE ADRREF.STD_RPTOUTFORMATTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTOUTFORMATTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTOUTFORMATTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_RPTOUTFORMATTYPEHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_RPTOUTFORMATTYPEHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_RPTOUTFORMATTYPEHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_RPTOUTFORMATTYPEHISTORY.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_RPTOUTFORMATTYPEHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_RPTOUTFORMATTYPEHISTORY ON ADRREF.STD_RPTOUTFORMATTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTOUTFORMAT161_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTOUTFORMATTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTOUTFORMATTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTOUTFORMATTYPEHISTORY FOR ADRREF.STD_RPTOUTFORMATTYPEHISTORY;


ALTER TABLE ADRREF.STD_RPTOUTFORMATTYPEHISTORY ADD (
  CONSTRAINT PK_STD_RPTOUTFORMATTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTOUTFORMATTYPEHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTOUTFORMATTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_RPTOUTFORMATTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTOUTFORMATTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTOUTFORMATTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTOUTFORMATTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTOUTFORMATTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTOUTFORMATTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTOUTFORMATTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_RPTOUTFORMATTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTOUTFORMATTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTOUTFORMATTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(100 BYTE)               NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTOUTFORMATTYPE ON ADRREF.STD_RPTOUTFORMATTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_RPTOUTFORMATTYPECODE ON ADRREF.STD_RPTOUTFORMATTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTOUTFORMAT146_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTOUTFORMATTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTOUTFORMATTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTOUTFORMATTYPE FOR ADRREF.STD_RPTOUTFORMATTYPE;


ALTER TABLE ADRREF.STD_RPTOUTFORMATTYPE ADD (
  CONSTRAINT PK_STD_RPTOUTFORMATTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTOUTFORMATTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RPTOUTFORMATTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_RPTOUTFORMATTYPECODE
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTOUTFORMATTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_RPTOUTFORMATTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTOUTFORMATTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTOUTFORMATTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTOUTFORMATTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTOUTFORMATTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTOUTFORMATTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTOUTFORMATTYPE TO PSIM;
ALTER TABLE ADRREF.STD_RPTMONTHLISTHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTMONTHLISTHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTMONTHLISTHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTMONTHLISTHISTORY ON ADRREF.STD_RPTMONTHLISTHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTMONTHLIST548_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTMONTHLISTHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTMONTHLISTHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTMONTHLISTHISTORY FOR ADRREF.STD_RPTMONTHLISTHISTORY;


ALTER TABLE ADRREF.STD_RPTMONTHLISTHISTORY ADD (
  CONSTRAINT PK_STD_RPTMONTHLISTHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTMONTHLISTHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTMONTHLISTHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_RPTMONTHLISTHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTMONTHLISTHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTMONTHLISTHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTMONTHLISTHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTMONTHLISTHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTMONTHLISTHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTMONTHLISTHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_RPTMONTHLIST
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTMONTHLIST CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTMONTHLIST
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_RPTMONTHLIST IS 'LOOKUP TABLE';

COMMENT ON COLUMN ADRREF.STD_RPTMONTHLIST.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_RPTMONTHLIST.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_RPTMONTHLIST.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_RPTMONTHLIST.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_RPTMONTHLIST.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_RPTMONTHLIST ON ADRREF.STD_RPTMONTHLIST
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_RPTMONTHLISTCODE ON ADRREF.STD_RPTMONTHLIST
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTMONTHLIST_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTMONTHLIST
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTMONTHLIST';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTMONTHLIST FOR ADRREF.STD_RPTMONTHLIST;


ALTER TABLE ADRREF.STD_RPTMONTHLIST ADD (
  CONSTRAINT PK_STD_RPTMONTHLIST
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTMONTHLIST
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RPTMONTHLISTCODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_RPTMONTHLISTCODE
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTMONTHLIST TO ADR;

GRANT SELECT ON ADRREF.STD_RPTMONTHLIST TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTMONTHLIST TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTMONTHLIST TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTMONTHLIST TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTMONTHLIST TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTMONTHLIST TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTMONTHLIST TO PSIM;
ALTER TABLE ADRREF.STD_RPTLETTERFILETYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTLETTERFILETYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTLETTERFILETYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTLETTERFILETYPEHSTRY ON ADRREF.STD_RPTLETTERFILETYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTLETTERFIL194_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTLETTERFILETYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTLETTERFILETYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTLETTERFILETYPEHISTORY FOR ADRREF.STD_RPTLETTERFILETYPEHISTORY;


ALTER TABLE ADRREF.STD_RPTLETTERFILETYPEHISTORY ADD (
  CONSTRAINT PK_STD_RPTLETTERFILETYPEHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTLETTERFILETYPEHSTRY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTLETTERFILETYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_RPTLETTERFILETYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTLETTERFILETYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTLETTERFILETYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTLETTERFILETYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTLETTERFILETYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTLETTERFILETYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTLETTERFILETYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_RPTLETTERFILETYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTLETTERFILETYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTLETTERFILETYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTLETTERFILETYPE ON ADRREF.STD_RPTLETTERFILETYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_RPTLETTERFILETYPECODE ON ADRREF.STD_RPTLETTERFILETYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTLETTERFIL148_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTLETTERFILETYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTLETTERFILETYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTLETTERFILETYPE FOR ADRREF.STD_RPTLETTERFILETYPE;


ALTER TABLE ADRREF.STD_RPTLETTERFILETYPE ADD (
  CONSTRAINT PK_STD_RPTLETTERFILETYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTLETTERFILETYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RPTLETTERFILETYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_RPTLETTERFILETYPECODE
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTLETTERFILETYPE TO ADR;

GRANT SELECT ON ADRREF.STD_RPTLETTERFILETYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTLETTERFILETYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTLETTERFILETYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTLETTERFILETYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTLETTERFILETYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTLETTERFILETYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTLETTERFILETYPE TO PSIM;
ALTER TABLE ADRREF.STD_RPTEXCEPTIONTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTEXCEPTIONTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTEXCEPTIONTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTEXCEPTIONTYPEHISTORY ON ADRREF.STD_RPTEXCEPTIONTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTEXCEPTION141_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTEXCEPTIONTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTEXCEPTIONTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTEXCEPTIONTYPEHISTORY FOR ADRREF.STD_RPTEXCEPTIONTYPEHISTORY;


ALTER TABLE ADRREF.STD_RPTEXCEPTIONTYPEHISTORY ADD (
  CONSTRAINT PK_STD_RPTEXCEPTIONTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTEXCEPTIONTYPEHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTEXCEPTIONTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_RPTEXCEPTIONTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTEXCEPTIONTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTEXCEPTIONTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTEXCEPTIONTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTEXCEPTIONTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTEXCEPTIONTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTEXCEPTIONTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_RPTEXCEPTIONTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTEXCEPTIONTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTEXCEPTIONTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(100 BYTE)               NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTEXCEPTIONTYPE ON ADRREF.STD_RPTEXCEPTIONTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_RPTEXCEPTIONTYPECODE ON ADRREF.STD_RPTEXCEPTIONTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTEXCEPTION129_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTEXCEPTIONTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTEXCEPTIONTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTEXCEPTIONTYPE FOR ADRREF.STD_RPTEXCEPTIONTYPE;


ALTER TABLE ADRREF.STD_RPTEXCEPTIONTYPE ADD (
  CONSTRAINT PK_STD_RPTEXCEPTIONTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTEXCEPTIONTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RPTEXCEPTIONTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_RPTEXCEPTIONTYPECODE
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTEXCEPTIONTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_RPTEXCEPTIONTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTEXCEPTIONTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTEXCEPTIONTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTEXCEPTIONTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTEXCEPTIONTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTEXCEPTIONTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTEXCEPTIONTYPE TO PSIM;
ALTER TABLE ADRREF.STD_RPTEEDWEEKLYTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTEEDWEEKLYTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTEEDWEEKLYTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTEEDWEEKLYTYPEHISTORY ON ADRREF.STD_RPTEEDWEEKLYTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTEEDWEEKLY188_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTEEDWEEKLYTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTEEDWEEKLYTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTEEDWEEKLYTYPEHISTORY FOR ADRREF.STD_RPTEEDWEEKLYTYPEHISTORY;


ALTER TABLE ADRREF.STD_RPTEEDWEEKLYTYPEHISTORY ADD (
  CONSTRAINT PK_STD_RPTEEDWEEKLYTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTEEDWEEKLYTYPEHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTEEDWEEKLYTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_RPTEEDWEEKLYTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTEEDWEEKLYTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTEEDWEEKLYTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTEEDWEEKLYTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTEEDWEEKLYTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTEEDWEEKLYTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTEEDWEEKLYTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_RPTEEDWEEKLYTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTEEDWEEKLYTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTEEDWEEKLYTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTEEDWEEKLYTYPE ON ADRREF.STD_RPTEEDWEEKLYTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_RPTEEDWEEKLYTYPECODE ON ADRREF.STD_RPTEEDWEEKLYTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTEEDWEEKLY113_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTEEDWEEKLYTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTEEDWEEKLYTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTEEDWEEKLYTYPE FOR ADRREF.STD_RPTEEDWEEKLYTYPE;


ALTER TABLE ADRREF.STD_RPTEEDWEEKLYTYPE ADD (
  CONSTRAINT PK_STD_RPTEEDWEEKLYTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTEEDWEEKLYTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RPTEEDWEEKLYTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_RPTEEDWEEKLYTYPECODE
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTEEDWEEKLYTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_RPTEEDWEEKLYTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTEEDWEEKLYTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTEEDWEEKLYTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTEEDWEEKLYTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTEEDWEEKLYTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTEEDWEEKLYTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTEEDWEEKLYTYPE TO PSIM;
ALTER TABLE ADRREF.STD_RPTDIVISIONTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTDIVISIONTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTDIVISIONTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTDIVISIONTYPEHISTORY ON ADRREF.STD_RPTDIVISIONTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTDIVISIONT105_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTDIVISIONTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTDIVISIONTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTDIVISIONTYPEHISTORY FOR ADRREF.STD_RPTDIVISIONTYPEHISTORY;


ALTER TABLE ADRREF.STD_RPTDIVISIONTYPEHISTORY ADD (
  CONSTRAINT PK_STD_RPTDIVISIONTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTDIVISIONTYPEHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTDIVISIONTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_RPTDIVISIONTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTDIVISIONTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDIVISIONTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDIVISIONTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTDIVISIONTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTDIVISIONTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDIVISIONTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_RPTDIVISIONTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTDIVISIONTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTDIVISIONTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(40 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_RPTDIVISIONTYPE IS 'LOOKUP TABLE';

COMMENT ON COLUMN ADRREF.STD_RPTDIVISIONTYPE.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_RPTDIVISIONTYPE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_RPTDIVISIONTYPE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_RPTDIVISIONTYPE.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_RPTDIVISIONTYPE.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_RPTDIVISIONTYPE ON ADRREF.STD_RPTDIVISIONTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_RPTDIVISIONTYPECODE ON ADRREF.STD_RPTDIVISIONTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_RPTDIVISIONTYPENAME ON ADRREF.STD_RPTDIVISIONTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTDIVISIONT189_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTDIVISIONTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTDIVISIONTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTDIVISIONTYPE FOR ADRREF.STD_RPTDIVISIONTYPE;


ALTER TABLE ADRREF.STD_RPTDIVISIONTYPE ADD (
  CONSTRAINT PK_STD_RPTDIVISIONTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTDIVISIONTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RPTDIVISIONTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_RPTDIVISIONTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RPTDIVISIONTYPENAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_RPTDIVISIONTYPENAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTDIVISIONTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_RPTDIVISIONTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTDIVISIONTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDIVISIONTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDIVISIONTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTDIVISIONTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTDIVISIONTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDIVISIONTYPE TO PSIM;
ALTER TABLE ADRREF.STD_RPTDETAILFORTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTDETAILFORTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTDETAILFORTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTDETAILFORTYPEHISTORY ON ADRREF.STD_RPTDETAILFORTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTDETAILFOR548_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTDETAILFORTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTDETAILFORTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTDETAILFORTYPEHISTORY FOR ADRREF.STD_RPTDETAILFORTYPEHISTORY;


ALTER TABLE ADRREF.STD_RPTDETAILFORTYPEHISTORY ADD (
  CONSTRAINT PK_STD_RPTDETAILFORTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTDETAILFORTYPEHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTDETAILFORTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_RPTDETAILFORTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTDETAILFORTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDETAILFORTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDETAILFORTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTDETAILFORTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTDETAILFORTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDETAILFORTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_RPTDETAILFORTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTDETAILFORTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTDETAILFORTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(50 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTDETAILFORTYPE ON ADRREF.STD_RPTDETAILFORTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_RPTDETAILFORTYPECODE ON ADRREF.STD_RPTDETAILFORTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTDETAILFOR114_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTDETAILFORTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTDETAILFORTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTDETAILFORTYPE FOR ADRREF.STD_RPTDETAILFORTYPE;


ALTER TABLE ADRREF.STD_RPTDETAILFORTYPE ADD (
  CONSTRAINT PK_STD_RPTDETAILFORTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTDETAILFORTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RPTDETAILFORTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_RPTDETAILFORTYPECODE
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTDETAILFORTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_RPTDETAILFORTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTDETAILFORTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDETAILFORTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDETAILFORTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTDETAILFORTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTDETAILFORTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDETAILFORTYPE TO PSIM;
ALTER TABLE ADRREF.STD_RPTDETAILBYTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTDETAILBYTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTDETAILBYTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_RPTDETAILBYTYPEHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_RPTDETAILBYTYPEHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_RPTDETAILBYTYPEHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_RPTDETAILBYTYPEHISTORY.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_RPTDETAILBYTYPEHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_RPTDETAILBYTYPEHISTORY ON ADRREF.STD_RPTDETAILBYTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTDETAILBYT185_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTDETAILBYTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTDETAILBYTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTDETAILBYTYPEHISTORY FOR ADRREF.STD_RPTDETAILBYTYPEHISTORY;


ALTER TABLE ADRREF.STD_RPTDETAILBYTYPEHISTORY ADD (
  CONSTRAINT PK_STD_RPTDETAILBYTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTDETAILBYTYPEHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTDETAILBYTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_RPTDETAILBYTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTDETAILBYTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDETAILBYTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDETAILBYTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTDETAILBYTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTDETAILBYTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDETAILBYTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_RPTDETAILBYTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTDETAILBYTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTDETAILBYTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_RPTDETAILBYTYPE ON ADRREF.STD_RPTDETAILBYTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_RPTDETAILBYTYPECODE ON ADRREF.STD_RPTDETAILBYTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTDETAILBYT688_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTDETAILBYTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTDETAILBYTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTDETAILBYTYPE FOR ADRREF.STD_RPTDETAILBYTYPE;


ALTER TABLE ADRREF.STD_RPTDETAILBYTYPE ADD (
  CONSTRAINT PK_STD_RPTDETAILBYTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTDETAILBYTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RPTDETAILBYTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_RPTDETAILBYTYPECODE
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTDETAILBYTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_RPTDETAILBYTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTDETAILBYTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDETAILBYTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDETAILBYTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTDETAILBYTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTDETAILBYTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDETAILBYTYPE TO PSIM;
ALTER TABLE ADRREF.STD_RPTDAYOFWEEKTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTDAYOFWEEKTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTDAYOFWEEKTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFWEEKTYPEHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFWEEKTYPEHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFWEEKTYPEHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFWEEKTYPEHISTORY.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFWEEKTYPEHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_RPTDAYOFWEEKTYPEHISTORY ON ADRREF.STD_RPTDAYOFWEEKTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTDAYOFWEEK207_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTDAYOFWEEKTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTDAYOFWEEKTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTDAYOFWEEKTYPEHISTORY FOR ADRREF.STD_RPTDAYOFWEEKTYPEHISTORY;


ALTER TABLE ADRREF.STD_RPTDAYOFWEEKTYPEHISTORY ADD (
  CONSTRAINT PK_STD_RPTDAYOFWEEKTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTDAYOFWEEKTYPEHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTDAYOFWEEKTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_RPTDAYOFWEEKTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTDAYOFWEEKTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDAYOFWEEKTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDAYOFWEEKTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTDAYOFWEEKTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTDAYOFWEEKTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDAYOFWEEKTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_RPTDAYOFWEEKTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTDAYOFWEEKTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTDAYOFWEEKTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_RPTDAYOFWEEKTYPE IS 'LOOKUP TABLE';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFWEEKTYPE.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFWEEKTYPE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFWEEKTYPE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFWEEKTYPE.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFWEEKTYPE.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_RPTDAYOFWEEKTYPE ON ADRREF.STD_RPTDAYOFWEEKTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_RPTDAYOFWEEKTYPECODE ON ADRREF.STD_RPTDAYOFWEEKTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTDAYOFWEEK128_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTDAYOFWEEKTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTDAYOFWEEKTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTDAYOFWEEKTYPE FOR ADRREF.STD_RPTDAYOFWEEKTYPE;


ALTER TABLE ADRREF.STD_RPTDAYOFWEEKTYPE ADD (
  CONSTRAINT PK_STD_RPTDAYOFWEEKTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTDAYOFWEEKTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RPTDAYOFWEEKTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_RPTDAYOFWEEKTYPECODE
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTDAYOFWEEKTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_RPTDAYOFWEEKTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTDAYOFWEEKTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDAYOFWEEKTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDAYOFWEEKTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTDAYOFWEEKTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTDAYOFWEEKTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDAYOFWEEKTYPE TO PSIM;
ALTER TABLE ADRREF.STD_RPTDAYOFQUARTERTYPHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTDAYOFQUARTERTYPHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTDAYOFQUARTERTYPHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFQUARTERTYPHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFQUARTERTYPHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFQUARTERTYPHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFQUARTERTYPHISTORY.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFQUARTERTYPHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_RPTDAYOFQUARTERTYPHSTRY ON ADRREF.STD_RPTDAYOFQUARTERTYPHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTDAYOFQUAR196_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTDAYOFQUARTERTYPHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTDAYOFQUARTERTYPHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTDAYOFQUARTERTYPHISTORY FOR ADRREF.STD_RPTDAYOFQUARTERTYPHISTORY;


ALTER TABLE ADRREF.STD_RPTDAYOFQUARTERTYPHISTORY ADD (
  CONSTRAINT PK_STD_RPTDAYOFQUARTERTYPHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTDAYOFQUARTERTYPHSTRY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTDAYOFQUARTERTYPHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_RPTDAYOFQUARTERTYPHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTDAYOFQUARTERTYPHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDAYOFQUARTERTYPHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDAYOFQUARTERTYPHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTDAYOFQUARTERTYPHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTDAYOFQUARTERTYPHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDAYOFQUARTERTYPHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_RPTDAYOFQUARTERTYP
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTDAYOFQUARTERTYP CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTDAYOFQUARTERTYP
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_RPTDAYOFQUARTERTYP IS 'LOOKUP TABLE';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFQUARTERTYP.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFQUARTERTYP.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFQUARTERTYP.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFQUARTERTYP.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFQUARTERTYP.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_RPTDAYOFQUARTERTYP ON ADRREF.STD_RPTDAYOFQUARTERTYP
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_RPTDAYOFQUARTERTYPCODE ON ADRREF.STD_RPTDAYOFQUARTERTYP
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTDAYOFQUAR200_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTDAYOFQUARTERTYP
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTDAYOFQUARTERTYP';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTDAYOFQUARTERTYP FOR ADRREF.STD_RPTDAYOFQUARTERTYP;


ALTER TABLE ADRREF.STD_RPTDAYOFQUARTERTYP ADD (
  CONSTRAINT PK_STD_RPTDAYOFQUARTERTYP
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTDAYOFQUARTERTYP
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RPTDAYOFQUARTERTYPCODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_RPTDAYOFQUARTERTYPCODE
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTDAYOFQUARTERTYP TO ADR;

GRANT SELECT ON ADRREF.STD_RPTDAYOFQUARTERTYP TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTDAYOFQUARTERTYP TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDAYOFQUARTERTYP TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDAYOFQUARTERTYP TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTDAYOFQUARTERTYP TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTDAYOFQUARTERTYP TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDAYOFQUARTERTYP TO PSIM;
ALTER TABLE ADRREF.STD_RPTDAYOFMONTHTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTDAYOFMONTHTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTDAYOFMONTHTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFMONTHTYPEHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFMONTHTYPEHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFMONTHTYPEHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFMONTHTYPEHISTORY.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFMONTHTYPEHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_RPTDAYOFMONTHTYPEHSTRY ON ADRREF.STD_RPTDAYOFMONTHTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTDAYOFMONT954_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTDAYOFMONTHTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTDAYOFMONTHTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTDAYOFMONTHTYPEHISTORY FOR ADRREF.STD_RPTDAYOFMONTHTYPEHISTORY;


ALTER TABLE ADRREF.STD_RPTDAYOFMONTHTYPEHISTORY ADD (
  CONSTRAINT PK_STD_RPTDAYOFMONTHTYPEHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTDAYOFMONTHTYPEHSTRY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTDAYOFMONTHTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_RPTDAYOFMONTHTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTDAYOFMONTHTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDAYOFMONTHTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDAYOFMONTHTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTDAYOFMONTHTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTDAYOFMONTHTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDAYOFMONTHTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_RPTDAYOFMONTHTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_RPTDAYOFMONTHTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_RPTDAYOFMONTHTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_RPTDAYOFMONTHTYPE IS 'LOOKUP TABLE';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFMONTHTYPE.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFMONTHTYPE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFMONTHTYPE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFMONTHTYPE.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_RPTDAYOFMONTHTYPE.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_RPTDAYOFMONTHTYPE ON ADRREF.STD_RPTDAYOFMONTHTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_RPTDAYOFMONTHTYPECODE ON ADRREF.STD_RPTDAYOFMONTHTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_RPTDAYOFMONT174_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_RPTDAYOFMONTHTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_RPTDAYOFMONTHTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_RPTDAYOFMONTHTYPE FOR ADRREF.STD_RPTDAYOFMONTHTYPE;


ALTER TABLE ADRREF.STD_RPTDAYOFMONTHTYPE ADD (
  CONSTRAINT PK_STD_RPTDAYOFMONTHTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_RPTDAYOFMONTHTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_RPTDAYOFMONTHTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_RPTDAYOFMONTHTYPECODE
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_RPTDAYOFMONTHTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_RPTDAYOFMONTHTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_RPTDAYOFMONTHTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_RPTDAYOFMONTHTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDAYOFMONTHTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_RPTDAYOFMONTHTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_RPTDAYOFMONTHTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_RPTDAYOFMONTHTYPE TO PSIM;
ALTER TABLE ADRREF.STD_REPORTTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_REPORTTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_REPORTTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_REPORTTYPEHISTORY ON ADRREF.STD_REPORTTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_REPORTTYPEHI172_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_REPORTTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_REPORTTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_REPORTTYPEHISTORY FOR ADRREF.STD_REPORTTYPEHISTORY;


ALTER TABLE ADRREF.STD_REPORTTYPEHISTORY ADD (
  CONSTRAINT PK_STD_REPORTTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_REPORTTYPEHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_REPORTTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_REPORTTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_REPORTTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_REPORTTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_REPORTTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_REPORTTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_REPORTTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_REPORTTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_REPORTTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_REPORTTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_REPORTTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_REPORTTYPE IS 'LOOKUP TABLE';

COMMENT ON COLUMN ADRREF.STD_REPORTTYPE.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_REPORTTYPE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_REPORTTYPE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_REPORTTYPE.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_REPORTTYPE.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_REPORTTYPE ON ADRREF.STD_REPORTTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_REPORTTYPECODE ON ADRREF.STD_REPORTTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_REPORTTYPE_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_REPORTTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_REPORTTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_REPORTTYPE FOR ADRREF.STD_REPORTTYPE;


ALTER TABLE ADRREF.STD_REPORTTYPE ADD (
  CONSTRAINT PK_STD_REPORTTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_REPORTTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_REPORTTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_REPORTTYPECODE
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_REPORTTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_REPORTTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_REPORTTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_REPORTTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_REPORTTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_REPORTTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_REPORTTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_REPORTTYPE TO PSIM;
ALTER TABLE ADRREF.STD_REPORTENROLLPRSTATHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_REPORTENROLLPRSTATHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_REPORTENROLLPRSTATHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_REPORTENROLLPRSTATHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_REPORTENROLLPRSTATHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_REPORTENROLLPRSTATHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_REPORTENROLLPRSTATHISTORY.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_REPORTENROLLPRSTATHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_REPORTENROLLPRSTATHSTRY ON ADRREF.STD_REPORTENROLLPRSTATHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_REPORTENROLL184_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_REPORTENROLLPRSTATHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_REPORTENROLLPRSTATHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_REPORTENROLLPRSTATHISTORY FOR ADRREF.STD_REPORTENROLLPRSTATHISTORY;


ALTER TABLE ADRREF.STD_REPORTENROLLPRSTATHISTORY ADD (
  CONSTRAINT PK_STD_REPORTENROLLPRSTATHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_REPORTENROLLPRSTATHSTRY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_REPORTENROLLPRSTATHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_REPORTENROLLPRSTATHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_REPORTENROLLPRSTATHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_REPORTENROLLPRSTATHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_REPORTENROLLPRSTATHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_REPORTENROLLPRSTATHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_REPORTENROLLPRSTATHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_REPORTENROLLPRSTATHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_REPORTENROLLPRSTAT
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_REPORTENROLLPRSTAT CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_REPORTENROLLPRSTAT
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(5 BYTE)                 NOT NULL,
  NAME         VARCHAR2(80 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_REPORTENROLLPRSTAT ON ADRREF.STD_REPORTENROLLPRSTAT
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_REPORTENROLLPRSTATCODE ON ADRREF.STD_REPORTENROLLPRSTAT
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_REPORTENROLLPRSTATNAME ON ADRREF.STD_REPORTENROLLPRSTAT
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_REPORTENROLL206_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_REPORTENROLLPRSTAT
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_REPORTENROLLPRSTAT';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_REPORTENROLLPRSTAT FOR ADRREF.STD_REPORTENROLLPRSTAT;


ALTER TABLE ADRREF.STD_REPORTENROLLPRSTAT ADD (
  CONSTRAINT PK_STD_REPORTENROLLPRSTAT
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_REPORTENROLLPRSTAT
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_REPORTENROLLPRSTATCODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_REPORTENROLLPRSTATCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_REPORTENROLLPRSTATNAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_REPORTENROLLPRSTATNAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_REPORTENROLLPRSTAT TO ADR;

GRANT SELECT ON ADRREF.STD_REPORTENROLLPRSTAT TO ADREXT;

GRANT SELECT ON ADRREF.STD_REPORTENROLLPRSTAT TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_REPORTENROLLPRSTAT TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_REPORTENROLLPRSTAT TO EESRV;

GRANT SELECT ON ADRREF.STD_REPORTENROLLPRSTAT TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_REPORTENROLLPRSTAT TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_REPORTENROLLPRSTAT TO PSIM;
ALTER TABLE ADRREF.STD_REPORTELIGFACTORHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_REPORTELIGFACTORHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_REPORTELIGFACTORHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_REPORTELIGFACTORHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_REPORTELIGFACTORHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_REPORTELIGFACTORHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_REPORTELIGFACTORHISTORY.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_REPORTELIGFACTORHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_REPORTELIGFACTORHISTORY ON ADRREF.STD_REPORTELIGFACTORHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_REPORTELIGFA204_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_REPORTELIGFACTORHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_REPORTELIGFACTORHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_REPORTELIGFACTORHISTORY FOR ADRREF.STD_REPORTELIGFACTORHISTORY;


ALTER TABLE ADRREF.STD_REPORTELIGFACTORHISTORY ADD (
  CONSTRAINT PK_STD_REPORTELIGFACTORHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_REPORTELIGFACTORHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_REPORTELIGFACTORHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_REPORTELIGFACTORHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_REPORTELIGFACTORHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_REPORTELIGFACTORHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_REPORTELIGFACTORHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_REPORTELIGFACTORHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_REPORTELIGFACTORHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_REPORTELIGFACTORHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_REPORTELIGFACTOR
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_REPORTELIGFACTOR CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_REPORTELIGFACTOR
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(5 BYTE)                 NOT NULL,
  NAME         VARCHAR2(80 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_REPORTELIGFACTOR IS 'Stub table for standard data services reference table.';

COMMENT ON COLUMN ADRREF.STD_REPORTELIGFACTOR.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_REPORTELIGFACTOR.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_REPORTELIGFACTOR.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_REPORTELIGFACTOR.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_REPORTELIGFACTOR.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_REPORTELIGFACTOR ON ADRREF.STD_REPORTELIGFACTOR
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_REPORTELIGFACTORCODE ON ADRREF.STD_REPORTELIGFACTOR
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_REPORTELIGFACTORNAME ON ADRREF.STD_REPORTELIGFACTOR
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_REPORTELIGFA119_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_REPORTELIGFACTOR
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_REPORTELIGFACTOR';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_REPORTELIGFACTOR FOR ADRREF.STD_REPORTELIGFACTOR;


ALTER TABLE ADRREF.STD_REPORTELIGFACTOR ADD (
  CONSTRAINT PK_STD_REPORTELIGFACTOR
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_REPORTELIGFACTOR
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_REPORTELIGFACTORCODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_REPORTELIGFACTORCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_REPORTELIGFACTORNAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_REPORTELIGFACTORNAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_REPORTELIGFACTOR TO ADR;

GRANT SELECT ON ADRREF.STD_REPORTELIGFACTOR TO ADREXT;

GRANT SELECT ON ADRREF.STD_REPORTELIGFACTOR TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_REPORTELIGFACTOR TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_REPORTELIGFACTOR TO EESRV;

GRANT SELECT ON ADRREF.STD_REPORTELIGFACTOR TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_REPORTELIGFACTOR TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_REPORTELIGFACTOR TO PSIM;
ALTER TABLE ADRREF.STD_PERMISSIONTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_PERMISSIONTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_PERMISSIONTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_PERMISSIONTYPEHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_PERMISSIONTYPEHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_PERMISSIONTYPEHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_PERMISSIONTYPEHISTORY.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_PERMISSIONTYPEHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_PERMISSIONTYPEHISTORY ON ADRREF.STD_PERMISSIONTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_PERMISSIONTY146_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_PERMISSIONTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_PERMISSIONTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PERMISSIONTYPEHISTORY FOR ADRREF.STD_PERMISSIONTYPEHISTORY;


ALTER TABLE ADRREF.STD_PERMISSIONTYPEHISTORY ADD (
  CONSTRAINT PK_STD_PERMISSIONTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_PERMISSIONTYPEHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_PERMISSIONTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_PERMISSIONTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_PERMISSIONTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_PERMISSIONTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_PERMISSIONTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_PERMISSIONTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_PERMISSIONTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_PERMISSIONTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_PERMISSIONTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_PERMISSIONTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_PERMISSIONTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(4 BYTE)                 NOT NULL,
  NAME         VARCHAR2(120 BYTE)               NOT NULL,
  DESCRIPTION  VARCHAR2(60 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_PERMISSIONTYPE ON ADRREF.STD_PERMISSIONTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_PERMISSIONTYPECODE ON ADRREF.STD_PERMISSIONTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_PERMISSIONTYPENAME ON ADRREF.STD_PERMISSIONTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_PERMISSIONTY523_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_PERMISSIONTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_PERMISSIONTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_PERMISSIONTYPE FOR ADRREF.STD_PERMISSIONTYPE;


ALTER TABLE ADRREF.STD_PERMISSIONTYPE ADD (
  CONSTRAINT PK_STD_PERMISSIONTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_PERMISSIONTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PERMISSIONTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_PERMISSIONTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_PERMISSIONTYPENAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_PERMISSIONTYPENAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_PERMISSIONTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_PERMISSIONTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_PERMISSIONTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_PERMISSIONTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_PERMISSIONTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_PERMISSIONTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_PERMISSIONTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_PERMISSIONTYPE TO PSIM;
ALTER TABLE ADRREF.STD_NCOAZIPNOMATCHTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_NCOAZIPNOMATCHTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_NCOAZIPNOMATCHTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_NCOAZIPNOMATCHTYPEHSTRY ON ADRREF.STD_NCOAZIPNOMATCHTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_NCOAZIPNOMAT526_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_NCOAZIPNOMATCHTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_NCOAZIPNOMATCHTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NCOAZIPNOMATCHTYPEHISTORY FOR ADRREF.STD_NCOAZIPNOMATCHTYPEHISTORY;


ALTER TABLE ADRREF.STD_NCOAZIPNOMATCHTYPEHISTORY ADD (
  CONSTRAINT PK_STD_NCOAZIPNOMATCHTYPEHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_NCOAZIPNOMATCHTYPEHSTRY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_NCOAZIPNOMATCHTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_NCOAZIPNOMATCHTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_NCOAZIPNOMATCHTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_NCOAZIPNOMATCHTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_NCOAZIPNOMATCHTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_NCOAZIPNOMATCHTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_NCOAZIPNOMATCHTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_NCOAZIPNOMATCHTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_NCOAZIPNOMATCHTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_NCOAZIPNOMATCHTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_NCOAZIPNOMATCHTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(1 BYTE)                 NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(60 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_NCOAZIPNOMATCHTYPE IS 'LOOKUP TABLE';

COMMENT ON COLUMN ADRREF.STD_NCOAZIPNOMATCHTYPE.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_NCOAZIPNOMATCHTYPE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_NCOAZIPNOMATCHTYPE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_NCOAZIPNOMATCHTYPE.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_NCOAZIPNOMATCHTYPE.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_NCOAZIPNOMATCHTYPE ON ADRREF.STD_NCOAZIPNOMATCHTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_NCOAZIPNOMATCHTYPECODE ON ADRREF.STD_NCOAZIPNOMATCHTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_NCOAZIPNOMATCHTYPENAME ON ADRREF.STD_NCOAZIPNOMATCHTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_NCOAZIPNOMAT115_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_NCOAZIPNOMATCHTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_NCOAZIPNOMATCHTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NCOAZIPNOMATCHTYPE FOR ADRREF.STD_NCOAZIPNOMATCHTYPE;


ALTER TABLE ADRREF.STD_NCOAZIPNOMATCHTYPE ADD (
  CONSTRAINT PK_STD_NCOAZIPNOMATCHTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_NCOAZIPNOMATCHTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_NCOAZIPNOMATCHTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_NCOAZIPNOMATCHTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_NCOAZIPNOMATCHTYPENAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_NCOAZIPNOMATCHTYPENAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_NCOAZIPNOMATCHTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_NCOAZIPNOMATCHTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_NCOAZIPNOMATCHTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_NCOAZIPNOMATCHTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_NCOAZIPNOMATCHTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_NCOAZIPNOMATCHTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_NCOAZIPNOMATCHTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_NCOAZIPNOMATCHTYPE TO PSIM;
ALTER TABLE ADRREF.STD_NCOAZIPMATCHTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_NCOAZIPMATCHTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_NCOAZIPMATCHTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_NCOAZIPMATCHTYPEHISTORY ON ADRREF.STD_NCOAZIPMATCHTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_NCOAZIPMATCH191_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_NCOAZIPMATCHTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_NCOAZIPMATCHTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NCOAZIPMATCHTYPEHISTORY FOR ADRREF.STD_NCOAZIPMATCHTYPEHISTORY;


ALTER TABLE ADRREF.STD_NCOAZIPMATCHTYPEHISTORY ADD (
  CONSTRAINT PK_STD_NCOAZIPMATCHTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_NCOAZIPMATCHTYPEHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_NCOAZIPMATCHTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_NCOAZIPMATCHTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_NCOAZIPMATCHTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_NCOAZIPMATCHTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_NCOAZIPMATCHTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_NCOAZIPMATCHTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_NCOAZIPMATCHTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_NCOAZIPMATCHTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_NCOAZIPMATCHTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_NCOAZIPMATCHTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_NCOAZIPMATCHTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         CHAR(1 BYTE)                     NOT NULL,
  NAME         VARCHAR2(100 BYTE)               NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_NCOAZIPMATCHTYPE IS 'LOOKUP TABLE';

COMMENT ON COLUMN ADRREF.STD_NCOAZIPMATCHTYPE.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_NCOAZIPMATCHTYPE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_NCOAZIPMATCHTYPE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_NCOAZIPMATCHTYPE.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_NCOAZIPMATCHTYPE.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_NCOAZIPMATCHTYPE ON ADRREF.STD_NCOAZIPMATCHTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_NCOAZIPMATCHTYPECODE ON ADRREF.STD_NCOAZIPMATCHTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_NCOAZIPMATCHTYPENAME ON ADRREF.STD_NCOAZIPMATCHTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_NCOAZIPMATCH923_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_NCOAZIPMATCHTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_NCOAZIPMATCHTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NCOAZIPMATCHTYPE FOR ADRREF.STD_NCOAZIPMATCHTYPE;


ALTER TABLE ADRREF.STD_NCOAZIPMATCHTYPE ADD (
  CONSTRAINT PK_STD_NCOAZIPMATCHTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_NCOAZIPMATCHTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_NCOAZIPMATCHTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_NCOAZIPMATCHTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_NCOAZIPMATCHTYPENAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_NCOAZIPMATCHTYPENAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_NCOAZIPMATCHTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_NCOAZIPMATCHTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_NCOAZIPMATCHTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_NCOAZIPMATCHTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_NCOAZIPMATCHTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_NCOAZIPMATCHTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_NCOAZIPMATCHTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_NCOAZIPMATCHTYPE TO PSIM;
ALTER TABLE ADRREF.STD_NCOASTATUSTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_NCOASTATUSTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_NCOASTATUSTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_NCOASTATUSTYPEHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_NCOASTATUSTYPEHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_NCOASTATUSTYPEHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_NCOASTATUSTYPEHISTORY.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_NCOASTATUSTYPEHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_NCOASTATUSTYPEHISTORY ON ADRREF.STD_NCOASTATUSTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_NCOASTATUSTY911_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_NCOASTATUSTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_NCOASTATUSTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NCOASTATUSTYPEHISTORY FOR ADRREF.STD_NCOASTATUSTYPEHISTORY;


ALTER TABLE ADRREF.STD_NCOASTATUSTYPEHISTORY ADD (
  CONSTRAINT PK_STD_NCOASTATUSTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_NCOASTATUSTYPEHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_NCOASTATUSTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_NCOASTATUSTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_NCOASTATUSTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_NCOASTATUSTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_NCOASTATUSTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_NCOASTATUSTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_NCOASTATUSTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_NCOASTATUSTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_NCOASTATUSTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_NCOASTATUSTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_NCOASTATUSTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_NCOASTATUSTYPE ON ADRREF.STD_NCOASTATUSTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_NCOASTATUSTYPECODE ON ADRREF.STD_NCOASTATUSTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_NCOASTATUSTYPENAME ON ADRREF.STD_NCOASTATUSTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_NCOASTATUSTY448_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_NCOASTATUSTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_NCOASTATUSTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NCOASTATUSTYPE FOR ADRREF.STD_NCOASTATUSTYPE;


ALTER TABLE ADRREF.STD_NCOASTATUSTYPE ADD (
  CONSTRAINT PK_STD_NCOASTATUSTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_NCOASTATUSTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_NCOASTATUSTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_NCOASTATUSTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_NCOASTATUSTYPENAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_NCOASTATUSTYPENAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_NCOASTATUSTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_NCOASTATUSTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_NCOASTATUSTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_NCOASTATUSTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_NCOASTATUSTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_NCOASTATUSTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_NCOASTATUSTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_NCOASTATUSTYPE TO PSIM;
ALTER TABLE ADRREF.STD_NCOADELIVERYTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_NCOADELIVERYTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_NCOADELIVERYTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_NCOADELIVERYTYPEHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_NCOADELIVERYTYPEHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_NCOADELIVERYTYPEHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_NCOADELIVERYTYPEHISTORY.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_NCOADELIVERYTYPEHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_NCOADELIVERYTYPEHISTORY ON ADRREF.STD_NCOADELIVERYTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_NCOADELIVERY612_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_NCOADELIVERYTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_NCOADELIVERYTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NCOADELIVERYTYPEHISTORY FOR ADRREF.STD_NCOADELIVERYTYPEHISTORY;


ALTER TABLE ADRREF.STD_NCOADELIVERYTYPEHISTORY ADD (
  CONSTRAINT PK_STD_NCOADELIVERYTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_NCOADELIVERYTYPEHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_NCOADELIVERYTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_NCOADELIVERYTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_NCOADELIVERYTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_NCOADELIVERYTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_NCOADELIVERYTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_NCOADELIVERYTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_NCOADELIVERYTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_NCOADELIVERYTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_NCOADELIVERYTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_NCOADELIVERYTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_NCOADELIVERYTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         CHAR(1 BYTE)                     NOT NULL,
  NAME         VARCHAR2(100 BYTE)               NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_NCOADELIVERYTYPE IS 'LOOKUP TABLE';

COMMENT ON COLUMN ADRREF.STD_NCOADELIVERYTYPE.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_NCOADELIVERYTYPE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_NCOADELIVERYTYPE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_NCOADELIVERYTYPE.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_NCOADELIVERYTYPE.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_NCOADELIVERYTYPE ON ADRREF.STD_NCOADELIVERYTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_NCOADELIVERYTYPECODE ON ADRREF.STD_NCOADELIVERYTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_NCOADELIVERYTYPENAME ON ADRREF.STD_NCOADELIVERYTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_NCOADELIVERY161_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_NCOADELIVERYTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_NCOADELIVERYTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_NCOADELIVERYTYPE FOR ADRREF.STD_NCOADELIVERYTYPE;


ALTER TABLE ADRREF.STD_NCOADELIVERYTYPE ADD (
  CONSTRAINT PK_STD_NCOADELIVERYTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_NCOADELIVERYTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_NCOADELIVERYTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_NCOADELIVERYTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_NCOADELIVERYTYPENAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_NCOADELIVERYTYPENAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_NCOADELIVERYTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_NCOADELIVERYTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_NCOADELIVERYTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_NCOADELIVERYTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_NCOADELIVERYTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_NCOADELIVERYTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_NCOADELIVERYTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_NCOADELIVERYTYPE TO PSIM;
ALTER TABLE ADRREF.STD_LANGUAGECODEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_LANGUAGECODEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_LANGUAGECODEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_LANGUAGECODEHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_LANGUAGECODEHISTORY.OWNER_ID IS 'Unknown';

COMMENT ON COLUMN ADRREF.STD_LANGUAGECODEHISTORY.ISACTIVE IS 'Unknown';

COMMENT ON COLUMN ADRREF.STD_LANGUAGECODEHISTORY.EFFECTIVEDATE IS 'Unknown';

COMMENT ON COLUMN ADRREF.STD_LANGUAGECODEHISTORY.EXPIRATIONDATE IS 'Unknown';

COMMENT ON COLUMN ADRREF.STD_LANGUAGECODEHISTORY.VERSION IS 'Unknown';

COMMENT ON COLUMN ADRREF.STD_LANGUAGECODEHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_LANGUAGECODEHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_LANGUAGECODEHISTORY.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_LANGUAGECODEHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.STD_LANGUAGECODEHISTORY_PK ON ADRREF.STD_LANGUAGECODEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_LANGUAGECODE555_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_LANGUAGECODEHISTORY
BEGIN
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP
 WHERE UPPER(tablename)='STD_LANGUAGECODEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_LANGUAGECODEHISTORY FOR ADRREF.STD_LANGUAGECODEHISTORY;


ALTER TABLE ADRREF.STD_LANGUAGECODEHISTORY ADD (
  CONSTRAINT STD_LANGUAGECODEHISTORY_PK
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.STD_LANGUAGECODEHISTORY_PK
  ENABLE VALIDATE);

ALTER TABLE ADRREF.STD_LANGUAGECODEHISTORY ADD (
  CONSTRAINT LNGCD_LNGCDHIS_FK 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES ADRREF.STD_LANGUAGECODE (ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADRREF.STD_LANGUAGECODEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_LANGUAGECODEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_LANGUAGECODEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_LANGUAGECODEHISTORY TO ADRREF_RW;

GRANT SELECT ON ADRREF.STD_LANGUAGECODEHISTORY TO ADR_R;

GRANT SELECT ON ADRREF.STD_LANGUAGECODEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_LANGUAGECODEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT SELECT ON ADRREF.STD_LANGUAGECODEHISTORY TO LOBR;

GRANT SELECT ON ADRREF.STD_LANGUAGECODEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_LANGUAGECODE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_LANGUAGECODE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_LANGUAGECODE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE_1       VARCHAR2(3 BYTE)                 NOT NULL,
  CODE         VARCHAR2(3 BYTE)                 NOT NULL,
  NAME         VARCHAR2(100 BYTE)               NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  SORT_ORDER   NUMBER(20)                       NOT NULL,
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_LANGUAGECODE.ID IS 'Primary Key';

COMMENT ON COLUMN ADRREF.STD_LANGUAGECODE.CODE_1 IS 'Content in field is from the ISO 639-1 column in the URL: http://www.loc.gov/standards/iso639-2/php/code_list.php';

COMMENT ON COLUMN ADRREF.STD_LANGUAGECODE.CODE IS 'Content in field is from the ISO 639-2 column in the URL: http://www.loc.gov/standards/iso639-2/php/code_list.php';

COMMENT ON COLUMN ADRREF.STD_LANGUAGECODE.CREATED IS 'Date record was created';

COMMENT ON COLUMN ADRREF.STD_LANGUAGECODE.UPDATED IS 'Date of this modification to the record';

COMMENT ON COLUMN ADRREF.STD_LANGUAGECODE.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_LANGUAGECODE.UPDATEDBY IS 'Account/user ID for this modification to the record';



CREATE UNIQUE INDEX ADRREF.STD_LANGUAGECODE_PK ON ADRREF.STD_LANGUAGECODE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_LANGUAGECODE867_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_LANGUAGECODE
BEGIN
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP
 WHERE UPPER(tablename)='STD_LANGUAGECODE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_LANGUAGECODE FOR ADRREF.STD_LANGUAGECODE;


ALTER TABLE ADRREF.STD_LANGUAGECODE ADD (
  CONSTRAINT STD_LANGUAGECODE_PK
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.STD_LANGUAGECODE_PK
  ENABLE VALIDATE);

GRANT REFERENCES, SELECT ON ADRREF.STD_LANGUAGECODE TO ADR;

GRANT SELECT ON ADRREF.STD_LANGUAGECODE TO ADREXT;

GRANT SELECT ON ADRREF.STD_LANGUAGECODE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_LANGUAGECODE TO ADRREF_RW;

GRANT SELECT ON ADRREF.STD_LANGUAGECODE TO ADR_R;

GRANT SELECT ON ADRREF.STD_LANGUAGECODE TO EESRV;

GRANT SELECT ON ADRREF.STD_LANGUAGECODE TO EEUSR WITH GRANT OPTION;

GRANT SELECT ON ADRREF.STD_LANGUAGECODE TO LOBR;

GRANT SELECT ON ADRREF.STD_LANGUAGECODE TO PSIM;
ALTER TABLE ADRREF.STD_HLTHBENEFITPLANTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_HLTHBENEFITPLANTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_HLTHBENEFITPLANTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.STD_HLTHBENEFITPLANTYPEH_PK ON ADRREF.STD_HLTHBENEFITPLANTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_HLTHBENPLNTYPH_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_HLTHBENEFITPLANTYPEHISTORY
BEGIN
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP
 WHERE UPPER(tablename)='STD_HLTHBENEFITPLANTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_HLTHBENEFITPLANTYPEHISTORY FOR ADRREF.STD_HLTHBENEFITPLANTYPEHISTORY;


ALTER TABLE ADRREF.STD_HLTHBENEFITPLANTYPEHISTORY ADD (
  CONSTRAINT STD_HLTHBENEFITPLANTYPEH_PK
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.STD_HLTHBENEFITPLANTYPEH_PK
  ENABLE VALIDATE);

ALTER TABLE ADRREF.STD_HLTHBENEFITPLANTYPEHISTORY ADD (
  CONSTRAINT HLTHBENEFITPLANTYPEH_FK 
  FOREIGN KEY (OWNER_ID) 
  REFERENCES ADRREF.STD_HLTHBENEFITPLANTYPE (ID)
  ENABLE VALIDATE);

GRANT REFERENCES, SELECT ON ADRREF.STD_HLTHBENEFITPLANTYPEHISTORY TO ADR;

GRANT REFERENCES, SELECT ON ADRREF.STD_HLTHBENEFITPLANTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_HLTHBENEFITPLANTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_HLTHBENEFITPLANTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_HLTHBENEFITPLANTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_HLTHBENEFITPLANTYPEHISTORY TO EEUSR WITH GRANT OPTION;
GRANT REFERENCES ON ADRREF.STD_HLTHBENEFITPLANTYPEHISTORY TO EEUSR;

GRANT REFERENCES, SELECT ON ADRREF.STD_HLTHBENEFITPLANTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_HLTHBENEFITPLANTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_HLTHBENEFITPLANTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_HLTHBENEFITPLANTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_HLTHBENEFITPLANTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(10 BYTE)                NOT NULL,
  NAME         VARCHAR2(200 BYTE)               NOT NULL,
  DESCRIPTION  VARCHAR2(200 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.STD_HLTHBENEFITPLANTPCDNM_UI ON ADRREF.STD_HLTHBENEFITPLANTYPE
(CODE, NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.STD_HLTHBENEFITPLANTYPE_PK ON ADRREF.STD_HLTHBENEFITPLANTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_HLTHBENPLNTYP_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_HLTHBENEFITPLANTYPE
BEGIN
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP
 WHERE UPPER(tablename)='STD_HLTHBENEFITPLANTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_HLTHBENEFITPLANTYPE FOR ADRREF.STD_HLTHBENEFITPLANTYPE;


ALTER TABLE ADRREF.STD_HLTHBENEFITPLANTYPE ADD (
  CONSTRAINT STD_HLTHBENEFITPLANTYPE_PK
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.STD_HLTHBENEFITPLANTYPE_PK
  ENABLE VALIDATE);

GRANT REFERENCES, SELECT ON ADRREF.STD_HLTHBENEFITPLANTYPE TO ADR;

GRANT REFERENCES, SELECT ON ADRREF.STD_HLTHBENEFITPLANTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_HLTHBENEFITPLANTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_HLTHBENEFITPLANTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_HLTHBENEFITPLANTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_HLTHBENEFITPLANTYPE TO EEUSR WITH GRANT OPTION;

GRANT REFERENCES, SELECT ON ADRREF.STD_HLTHBENEFITPLANTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_HLTHBENEFITPLANTYPE TO PSIM;
ALTER TABLE ADRREF.STD_HANDBOOKRELEASECONTROL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_HANDBOOKRELEASECONTROL CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_HANDBOOKRELEASECONTROL
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(3)                        NOT NULL,
  NAME         VARCHAR2(30 BYTE),
  DESCRIPTION  VARCHAR2(250 BYTE),
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_HANDBOOKRELEASECONTROL IS 'Description of a release of a Handbook';

COMMENT ON COLUMN ADRREF.STD_HANDBOOKRELEASECONTROL.CODE IS 'Published version of the document. Reflecting rules the document was created under. Synonym for Communications ID. Controls which release of the Veterans Health Benefits
Handbook is being generated. This will allow the Members Benefits Division to control a refresh of the Veterans Health Benefits Handbook when changes occur to the content. For example, changes to the content due to new regulations
require Veterans to be notified. The actor will enter a new Release Control Number in order to publish the new Veterans Health Benefits Handbooks. Also used for New Enrollees in order to provide the identification for which Veterans
Health Benefits Handbook the veteran received 1 thru 99 sequentally';

COMMENT ON COLUMN ADRREF.STD_HANDBOOKRELEASECONTROL.NAME IS 'Ex. Release control number 1, Release control number 2, etc....';

COMMENT ON COLUMN ADRREF.STD_HANDBOOKRELEASECONTROL.DESCRIPTION IS 'Ex. handbook edition 1, handbook edition 2, etc';

COMMENT ON COLUMN ADRREF.STD_HANDBOOKRELEASECONTROL.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_HANDBOOKRELEASECONTROL.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_HANDBOOKRELEASECONTROL.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_HANDBOOKRELEASECONTROL.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.STDHNDRELCNTR_PK ON ADRREF.STD_HANDBOOKRELEASECONTROL
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM STD_HANDBOOKRELEASECONTROL FOR ADRREF.STD_HANDBOOKRELEASECONTROL;


ALTER TABLE ADRREF.STD_HANDBOOKRELEASECONTROL ADD (
  CONSTRAINT HANDBOOK_RELEASE_CONTROL_PK
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.STDHNDRELCNTR_PK
  ENABLE VALIDATE);

GRANT REFERENCES ON ADRREF.STD_HANDBOOKRELEASECONTROL TO ADR;

GRANT SELECT ON ADRREF.STD_HANDBOOKRELEASECONTROL TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_HANDBOOKRELEASECONTROL TO ADRREF_RW;
ALTER TABLE ADRREF.STD_HANDBOOKMAILSTATTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_HANDBOOKMAILSTATTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_HANDBOOKMAILSTATTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(30 BYTE)                NOT NULL,
  NAME         VARCHAR2(30 BYTE),
  DESCRIPTION  VARCHAR2(250 BYTE),
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_HANDBOOKMAILSTATTYPE IS 'Lookup Table';

COMMENT ON COLUMN ADRREF.STD_HANDBOOKMAILSTATTYPE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_HANDBOOKMAILSTATTYPE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_HANDBOOKMAILSTATTYPE.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_HANDBOOKMAILSTATTYPE.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.STDHNDBKMALSTATYP_PK ON ADRREF.STD_HANDBOOKMAILSTATTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM STD_HANDBOOKMAILSTATTYPE FOR ADRREF.STD_HANDBOOKMAILSTATTYPE;


ALTER TABLE ADRREF.STD_HANDBOOKMAILSTATTYPE ADD (
  CONSTRAINT STDHNDBKMALSTATYP_PK
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.STDHNDBKMALSTATYP_PK
  ENABLE VALIDATE);

GRANT REFERENCES ON ADRREF.STD_HANDBOOKMAILSTATTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_HANDBOOKMAILSTATTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_HANDBOOKMAILSTATTYPE TO ADRREF_RW;
ALTER TABLE ADRREF.STD_HANDBOOKBATCHREQUESTSTATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_HANDBOOKBATCHREQUESTSTATUS CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_HANDBOOKBATCHREQUESTSTATUS
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(30 BYTE)                NOT NULL,
  NAME         VARCHAR2(30 BYTE),
  DESCRIPTION  VARCHAR2(250 BYTE),
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_HANDBOOKBATCHREQUESTSTATUS IS 'Current status of a Handbook document request.  Examples  request file pushed to CMS,
digital copy retrieved,
error file,
code 1 reject file';

COMMENT ON COLUMN ADRREF.STD_HANDBOOKBATCHREQUESTSTATUS.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_HANDBOOKBATCHREQUESTSTATUS.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_HANDBOOKBATCHREQUESTSTATUS.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_HANDBOOKBATCHREQUESTSTATUS.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.STDHNDREQSTAT_PK ON ADRREF.STD_HANDBOOKBATCHREQUESTSTATUS
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM STD_HANDBOOKBATCHREQUESTSTATUS FOR ADRREF.STD_HANDBOOKBATCHREQUESTSTATUS;


ALTER TABLE ADRREF.STD_HANDBOOKBATCHREQUESTSTATUS ADD (
  CONSTRAINT HNDBATCHREQSTAT_PK
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.STDHNDREQSTAT_PK
  ENABLE VALIDATE);

GRANT REFERENCES ON ADRREF.STD_HANDBOOKBATCHREQUESTSTATUS TO ADR;

GRANT SELECT ON ADRREF.STD_HANDBOOKBATCHREQUESTSTATUS TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_HANDBOOKBATCHREQUESTSTATUS TO ADRREF_RW;
ALTER TABLE ADRREF.STD_ENROLL_APPLICATION_STATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_ENROLL_APPLICATION_STATUS CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_ENROLL_APPLICATION_STATUS
(
  STD_ENROLL_APPLICATION_STA_ID  NUMBER(20)     NOT NULL,
  NAME                           VARCHAR2(100 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_ENROLL_APPLICATION_STATUS.STD_ENROLL_APPLICATION_STA_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_ENROLL_APPLICATION_STATUS.NAME IS 'Completion status of  the application.';



CREATE UNIQUE INDEX ADRREF.STDENRAPPSTA_PK ON ADRREF.STD_ENROLL_APPLICATION_STATUS
(STD_ENROLL_APPLICATION_STA_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM STD_ENROLL_APPLICATION_STATUS FOR ADRREF.STD_ENROLL_APPLICATION_STATUS;


ALTER TABLE ADRREF.STD_ENROLL_APPLICATION_STATUS ADD (
  CONSTRAINT STDENRAPPSTA_PK
  PRIMARY KEY
  (STD_ENROLL_APPLICATION_STA_ID)
  USING INDEX ADRREF.STDENRAPPSTA_PK
  ENABLE VALIDATE);

GRANT REFERENCES, SELECT ON ADRREF.STD_ENROLL_APPLICATION_STATUS TO ADRAAP;

GRANT SELECT ON ADRREF.STD_ENROLL_APPLICATION_STATUS TO ADRREF_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADRREF.STD_ENROLL_APPLICATION_STATUS TO ADRREF_RW;

GRANT SELECT ON ADRREF.STD_ENROLL_APPLICATION_STATUS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADRREF.STD_ENROLL_APPLICATION_STATUS TO ADR_RW;

GRANT SELECT ON ADRREF.STD_ENROLL_APPLICATION_STATUS TO EESRV_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADRREF.STD_ENROLL_APPLICATION_STATUS TO EESRV_RW;
ALTER TABLE ADRREF.STD_ENROLL_APPLICATION_METHOD
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_ENROLL_APPLICATION_METHOD CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_ENROLL_APPLICATION_METHOD
(
  STD_ENROLL_APPLICATION_MTH_ID  NUMBER(20)     NOT NULL,
  NAME                           VARCHAR2(100 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_ENROLL_APPLICATION_METHOD IS 'How the enrollment application was received.';

COMMENT ON COLUMN ADRREF.STD_ENROLL_APPLICATION_METHOD.STD_ENROLL_APPLICATION_MTH_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_ENROLL_APPLICATION_METHOD.NAME IS 'Name of the method by which the enrollment application was recieved.';



CREATE UNIQUE INDEX ADRREF.STDENRAPPMTH_PK ON ADRREF.STD_ENROLL_APPLICATION_METHOD
(STD_ENROLL_APPLICATION_MTH_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM STD_ENROLL_APPLICATION_METHOD FOR ADRREF.STD_ENROLL_APPLICATION_METHOD;


ALTER TABLE ADRREF.STD_ENROLL_APPLICATION_METHOD ADD (
  CONSTRAINT STDENRAPPMTH_PK
  PRIMARY KEY
  (STD_ENROLL_APPLICATION_MTH_ID)
  USING INDEX ADRREF.STDENRAPPMTH_PK
  ENABLE VALIDATE);

GRANT REFERENCES, SELECT ON ADRREF.STD_ENROLL_APPLICATION_METHOD TO ADRAAP;

GRANT SELECT ON ADRREF.STD_ENROLL_APPLICATION_METHOD TO ADRREF_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADRREF.STD_ENROLL_APPLICATION_METHOD TO ADRREF_RW;

GRANT SELECT ON ADRREF.STD_ENROLL_APPLICATION_METHOD TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADRREF.STD_ENROLL_APPLICATION_METHOD TO ADR_RW;

GRANT SELECT ON ADRREF.STD_ENROLL_APPLICATION_METHOD TO EESRV_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADRREF.STD_ENROLL_APPLICATION_METHOD TO EESRV_RW;
ALTER TABLE ADRREF.STD_COMREJECTREASONTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_COMREJECTREASONTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_COMREJECTREASONTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_COMREJECTREASONTYPEHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_COMREJECTREASONTYPEHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_COMREJECTREASONTYPEHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_COMREJECTREASONTYPEHISTORY.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_COMREJECTREASONTYPEHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_COMREJECTREASONTYPHSTRY ON ADRREF.STD_COMREJECTREASONTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_COMREJECTREA181_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_COMREJECTREASONTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_COMREJECTREASONTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_COMREJECTREASONTYPEHISTORY FOR ADRREF.STD_COMREJECTREASONTYPEHISTORY;


ALTER TABLE ADRREF.STD_COMREJECTREASONTYPEHISTORY ADD (
  CONSTRAINT PK_STD_COMREJECTREASONTYPHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_COMREJECTREASONTYPHSTRY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_COMREJECTREASONTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_COMREJECTREASONTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_COMREJECTREASONTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMREJECTREASONTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMREJECTREASONTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_COMREJECTREASONTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_COMREJECTREASONTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMREJECTREASONTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_COMREJECTREASONTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_COMREJECTREASONTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_COMREJECTREASONTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         CHAR(1 BYTE)                     NOT NULL,
  NAME         VARCHAR2(100 BYTE)               NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_COMREJECTREASONTYPE IS 'LOOKUP TABLE';

COMMENT ON COLUMN ADRREF.STD_COMREJECTREASONTYPE.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_COMREJECTREASONTYPE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_COMREJECTREASONTYPE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_COMREJECTREASONTYPE.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_COMREJECTREASONTYPE.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_COMREJECTREASONTYPE ON ADRREF.STD_COMREJECTREASONTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_COMREJECTREASONTYPECODE ON ADRREF.STD_COMREJECTREASONTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_COMREJECTREASONTYPENAME ON ADRREF.STD_COMREJECTREASONTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_COMREJECTREA133_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_COMREJECTREASONTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_COMREJECTREASONTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_COMREJECTREASONTYPE FOR ADRREF.STD_COMREJECTREASONTYPE;


ALTER TABLE ADRREF.STD_COMREJECTREASONTYPE ADD (
  CONSTRAINT PK_STD_COMREJECTREASONTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_COMREJECTREASONTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_COMREJECTREASONTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_COMREJECTREASONTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_COMREJECTREASONTYPENAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_COMREJECTREASONTYPENAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_COMREJECTREASONTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_COMREJECTREASONTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_COMREJECTREASONTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMREJECTREASONTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMREJECTREASONTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_COMREJECTREASONTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_COMREJECTREASONTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMREJECTREASONTYPE TO PSIM;
ALTER TABLE ADRREF.STD_COMMMLTRIGGERTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_COMMMLTRIGGERTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_COMMMLTRIGGERTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_COMMMLTRIGGERTYPEHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_COMMMLTRIGGERTYPEHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_COMMMLTRIGGERTYPEHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_COMMMLTRIGGERTYPEHISTORY.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_COMMMLTRIGGERTYPEHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_COMMMLTRIGGERTYPEHSTRY ON ADRREF.STD_COMMMLTRIGGERTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_COMMMLTRIGGE396_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_COMMMLTRIGGERTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_COMMMLTRIGGERTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_COMMMLTRIGGERTYPEHISTORY FOR ADRREF.STD_COMMMLTRIGGERTYPEHISTORY;


ALTER TABLE ADRREF.STD_COMMMLTRIGGERTYPEHISTORY ADD (
  CONSTRAINT PK_STD_COMMMLTRIGGERTYPEHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_COMMMLTRIGGERTYPEHSTRY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_COMMMLTRIGGERTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_COMMMLTRIGGERTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_COMMMLTRIGGERTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMMMLTRIGGERTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMMMLTRIGGERTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_COMMMLTRIGGERTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_COMMMLTRIGGERTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMMMLTRIGGERTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_COMMMLTRIGGERTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_COMMMLTRIGGERTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_COMMMLTRIGGERTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_COMMMLTRIGGERTYPE IS 'LOOKUP TABLE';

COMMENT ON COLUMN ADRREF.STD_COMMMLTRIGGERTYPE.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_COMMMLTRIGGERTYPE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_COMMMLTRIGGERTYPE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_COMMMLTRIGGERTYPE.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_COMMMLTRIGGERTYPE.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_COMMMLTRIGGERTYPE ON ADRREF.STD_COMMMLTRIGGERTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_COMMMLTRIGGERTYPECODE ON ADRREF.STD_COMMMLTRIGGERTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_COMMMLTRIGGE120_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_COMMMLTRIGGERTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_COMMMLTRIGGERTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_COMMMLTRIGGERTYPE FOR ADRREF.STD_COMMMLTRIGGERTYPE;


ALTER TABLE ADRREF.STD_COMMMLTRIGGERTYPE ADD (
  CONSTRAINT PK_STD_COMMMLTRIGGERTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_COMMMLTRIGGERTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_COMMMLTRIGGERTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_COMMMLTRIGGERTYPECODE
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_COMMMLTRIGGERTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_COMMMLTRIGGERTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_COMMMLTRIGGERTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMMMLTRIGGERTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMMMLTRIGGERTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_COMMMLTRIGGERTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_COMMMLTRIGGERTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMMMLTRIGGERTYPE TO PSIM;
ALTER TABLE ADRREF.STD_COMMMAILINGSTTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_COMMMAILINGSTTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_COMMMAILINGSTTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_COMMMAILINGSTTYPEHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_COMMMAILINGSTTYPEHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_COMMMAILINGSTTYPEHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_COMMMAILINGSTTYPEHISTORY.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_COMMMAILINGSTTYPEHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_COMMMAILINGSTTYPEHSTRY ON ADRREF.STD_COMMMAILINGSTTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_COMMMAILINGS686_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_COMMMAILINGSTTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_COMMMAILINGSTTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_COMMMAILINGSTTYPEHISTORY FOR ADRREF.STD_COMMMAILINGSTTYPEHISTORY;


ALTER TABLE ADRREF.STD_COMMMAILINGSTTYPEHISTORY ADD (
  CONSTRAINT PK_STD_COMMMAILINGSTTYPEHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_COMMMAILINGSTTYPEHSTRY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_COMMMAILINGSTTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_COMMMAILINGSTTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_COMMMAILINGSTTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMMMAILINGSTTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMMMAILINGSTTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_COMMMAILINGSTTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_COMMMAILINGSTTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMMMAILINGSTTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_COMMMAILINGSTTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_COMMMAILINGSTTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_COMMMAILINGSTTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(2 BYTE)                 NOT NULL,
  NAME         VARCHAR2(40 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_COMMMAILINGSTTYPE ON ADRREF.STD_COMMMAILINGSTTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_COMMMAILINGSTTYPECODE ON ADRREF.STD_COMMMAILINGSTTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_COMMMAILINGSTTYPENAME ON ADRREF.STD_COMMMAILINGSTTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_COMMMAILINGS143_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_COMMMAILINGSTTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_COMMMAILINGSTTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_COMMMAILINGSTTYPE FOR ADRREF.STD_COMMMAILINGSTTYPE;


ALTER TABLE ADRREF.STD_COMMMAILINGSTTYPE ADD (
  CONSTRAINT PK_STD_COMMMAILINGSTTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_COMMMAILINGSTTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_COMMMAILINGSTTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_COMMMAILINGSTTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_COMMMAILINGSTTYPENAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_COMMMAILINGSTTYPENAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_COMMMAILINGSTTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_COMMMAILINGSTTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_COMMMAILINGSTTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMMMAILINGSTTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMMMAILINGSTTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_COMMMAILINGSTTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_COMMMAILINGSTTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMMMAILINGSTTYPE TO PSIM;
ALTER TABLE ADRREF.STD_COMMLETTERTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_COMMLETTERTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_COMMLETTERTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_COMMLETTERTYPEHISTORY ON ADRREF.STD_COMMLETTERTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_COMMLETTERTY409_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_COMMLETTERTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_COMMLETTERTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_COMMLETTERTYPEHISTORY FOR ADRREF.STD_COMMLETTERTYPEHISTORY;


ALTER TABLE ADRREF.STD_COMMLETTERTYPEHISTORY ADD (
  CONSTRAINT PK_STD_COMMLETTERTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_COMMLETTERTYPEHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_COMMLETTERTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_COMMLETTERTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_COMMLETTERTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMMLETTERTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMMLETTERTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_COMMLETTERTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_COMMLETTERTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMMLETTERTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_COMMLETTERTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_COMMLETTERTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_COMMLETTERTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(2 BYTE)                 NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_COMMLETTERTYPE ON ADRREF.STD_COMMLETTERTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_COMMLETTERTYPECODE ON ADRREF.STD_COMMLETTERTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_COMMLETTERTYPENAME ON ADRREF.STD_COMMLETTERTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_COMMLETTERTY116_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_COMMLETTERTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_COMMLETTERTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_COMMLETTERTYPE FOR ADRREF.STD_COMMLETTERTYPE;


ALTER TABLE ADRREF.STD_COMMLETTERTYPE ADD (
  CONSTRAINT PK_STD_COMMLETTERTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_COMMLETTERTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_COMMLETTERTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_COMMLETTERTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_COMMLETTERTYPENAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_COMMLETTERTYPENAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_COMMLETTERTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_COMMLETTERTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_COMMLETTERTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMMLETTERTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMMLETTERTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_COMMLETTERTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_COMMLETTERTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMMLETTERTYPE TO PSIM;
ALTER TABLE ADRREF.STD_COMMLETTERGENTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_COMMLETTERGENTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_COMMLETTERGENTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_COMMLETTERGENTYPEHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_COMMLETTERGENTYPEHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_COMMLETTERGENTYPEHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_COMMLETTERGENTYPEHISTORY.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_COMMLETTERGENTYPEHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_COMMLETTERGENTYPEHSTRY ON ADRREF.STD_COMMLETTERGENTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_COMMLETTERGE172_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_COMMLETTERGENTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_COMMLETTERGENTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_COMMLETTERGENTYPEHISTORY FOR ADRREF.STD_COMMLETTERGENTYPEHISTORY;


ALTER TABLE ADRREF.STD_COMMLETTERGENTYPEHISTORY ADD (
  CONSTRAINT PK_STD_COMMLETTERGENTYPEHSTRY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_COMMLETTERGENTYPEHSTRY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_COMMLETTERGENTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_COMMLETTERGENTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_COMMLETTERGENTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMMLETTERGENTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMMLETTERGENTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_COMMLETTERGENTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_COMMLETTERGENTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMMLETTERGENTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_COMMLETTERGENTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_COMMLETTERGENTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_COMMLETTERGENTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(2 BYTE)                 NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_COMMLETTERGENTYPE IS 'LOOKUP TABLE';

COMMENT ON COLUMN ADRREF.STD_COMMLETTERGENTYPE.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_COMMLETTERGENTYPE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_COMMLETTERGENTYPE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_COMMLETTERGENTYPE.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_COMMLETTERGENTYPE.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_COMMLETTERGENTYPE ON ADRREF.STD_COMMLETTERGENTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_COMMLETTERGENTYPECODE ON ADRREF.STD_COMMLETTERGENTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_COMMLETTERGENTYPENAME ON ADRREF.STD_COMMLETTERGENTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_COMMLETTERGE191_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_COMMLETTERGENTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_COMMLETTERGENTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_COMMLETTERGENTYPE FOR ADRREF.STD_COMMLETTERGENTYPE;


ALTER TABLE ADRREF.STD_COMMLETTERGENTYPE ADD (
  CONSTRAINT PK_STD_COMMLETTERGENTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_COMMLETTERGENTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_COMMLETTERGENTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_COMMLETTERGENTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_COMMLETTERGENTYPENAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_COMMLETTERGENTYPENAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_COMMLETTERGENTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_COMMLETTERGENTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_COMMLETTERGENTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMMLETTERGENTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMMLETTERGENTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_COMMLETTERGENTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_COMMLETTERGENTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMMLETTERGENTYPE TO PSIM;
ALTER TABLE ADRREF.STD_COMMERRORTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_COMMERRORTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_COMMERRORTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_COMMERRORTYPEHISTORY ON ADRREF.STD_COMMERRORTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_COMMERRORTYP907_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_COMMERRORTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_COMMERRORTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_COMMERRORTYPEHISTORY FOR ADRREF.STD_COMMERRORTYPEHISTORY;


ALTER TABLE ADRREF.STD_COMMERRORTYPEHISTORY ADD (
  CONSTRAINT PK_STD_COMMERRORTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_COMMERRORTYPEHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_COMMERRORTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_COMMERRORTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_COMMERRORTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMMERRORTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMMERRORTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_COMMERRORTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_COMMERRORTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMMERRORTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_COMMERRORTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_COMMERRORTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_COMMERRORTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         CHAR(3 BYTE)                     NOT NULL,
  NAME         VARCHAR2(100 BYTE)               NOT NULL,
  DESCRIPTION  VARCHAR2(100 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_COMMERRORTYPE ON ADRREF.STD_COMMERRORTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_COMMERRORTYPECODE ON ADRREF.STD_COMMERRORTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_COMMERRORTYPENAME ON ADRREF.STD_COMMERRORTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_COMMERRORTYP384_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_COMMERRORTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_COMMERRORTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_COMMERRORTYPE FOR ADRREF.STD_COMMERRORTYPE;


ALTER TABLE ADRREF.STD_COMMERRORTYPE ADD (
  CONSTRAINT PK_STD_COMMERRORTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_COMMERRORTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_COMMERRORTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_COMMERRORTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_COMMERRORTYPENAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_COMMERRORTYPENAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_COMMERRORTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_COMMERRORTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_COMMERRORTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_COMMERRORTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMMERRORTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_COMMERRORTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_COMMERRORTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_COMMERRORTYPE TO PSIM;
ALTER TABLE ADRREF.STD_CLVERIFICATIONTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_CLVERIFICATIONTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_CLVERIFICATIONTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_CLVERIFICATIONTYPEHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_CLVERIFICATIONTYPEHISTORY.OWNER_ID IS 'Unknown';

COMMENT ON COLUMN ADRREF.STD_CLVERIFICATIONTYPEHISTORY.ISACTIVE IS 'Unknown';

COMMENT ON COLUMN ADRREF.STD_CLVERIFICATIONTYPEHISTORY.EFFECTIVEDATE IS 'Unknown';

COMMENT ON COLUMN ADRREF.STD_CLVERIFICATIONTYPEHISTORY.EXPIRATIONDATE IS 'Unknown';

COMMENT ON COLUMN ADRREF.STD_CLVERIFICATIONTYPEHISTORY.VERSION IS 'Unknown';

COMMENT ON COLUMN ADRREF.STD_CLVERIFICATIONTYPEHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_CLVERIFICATIONTYPEHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_CLVERIFICATIONTYPEHISTORY.CREATEDBY IS 'Account/user ID that created the record.';

COMMENT ON COLUMN ADRREF.STD_CLVERIFICATIONTYPEHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.STD_CLVERIFICATIONTYPHIST_PK ON ADRREF.STD_CLVERIFICATIONTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_CLVERIFTYPE_H_AUDIR_TRG
   AFTER DELETE OR INSERT OR UPDATE
   ON ADRREF.STD_CLVERIFICATIONTYPEHISTORY
BEGIN
   UPDATE ADRREF.tablemanager
      SET LASTUPDATED = CURRENT_TIMESTAMP
    WHERE UPPER (tablename) = 'STD_CLVERIFICATIONTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_CLVERIFICATIONTYPEHISTORY FOR ADRREF.STD_CLVERIFICATIONTYPEHISTORY;


ALTER TABLE ADRREF.STD_CLVERIFICATIONTYPEHISTORY ADD (
  CONSTRAINT STD_CLVERIFICATIONTYPHIST_PK
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.STD_CLVERIFICATIONTYPHIST_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADRREF.STD_CLVERIFICATIONTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_CLVERIFICATIONTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_CLVERIFICATIONTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_CLVERIFICATIONTYPEHISTORY TO ADRREF_RW;

GRANT SELECT ON ADRREF.STD_CLVERIFICATIONTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_CLVERIFICATIONTYPEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT SELECT ON ADRREF.STD_CLVERIFICATIONTYPEHISTORY TO LOBR;

GRANT SELECT ON ADRREF.STD_CLVERIFICATIONTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_CLVERIFICATIONTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_CLVERIFICATIONTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_CLVERIFICATIONTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(10 BYTE)                NOT NULL,
  NAME         VARCHAR2(200 BYTE)               NOT NULL,
  DESCRIPTION  VARCHAR2(200 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_CLVERIFICATIONTYPE IS 'LOOKUP TABLE';

COMMENT ON COLUMN ADRREF.STD_CLVERIFICATIONTYPE.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_CLVERIFICATIONTYPE.CODE IS 'Unknown';

COMMENT ON COLUMN ADRREF.STD_CLVERIFICATIONTYPE.NAME IS 'Verification method used to determine Camp Lejeune eligibility.';

COMMENT ON COLUMN ADRREF.STD_CLVERIFICATIONTYPE.DESCRIPTION IS 'Unknown';

COMMENT ON COLUMN ADRREF.STD_CLVERIFICATIONTYPE.VERSION IS 'Unknown';

COMMENT ON COLUMN ADRREF.STD_CLVERIFICATIONTYPE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_CLVERIFICATIONTYPE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_CLVERIFICATIONTYPE.CREATEDBY IS 'Account/user ID that created the record.';

COMMENT ON COLUMN ADRREF.STD_CLVERIFICATIONTYPE.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.STD_CLVERIFICATIONTYPE_PK ON ADRREF.STD_CLVERIFICATIONTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_CLVERIFTYPE_AUDIR_TRG
   AFTER DELETE OR INSERT OR UPDATE
   ON ADRREF.STD_CLVERIFICATIONTYPE
BEGIN
   UPDATE ADRREF.tablemanager
      SET LASTUPDATED = CURRENT_TIMESTAMP
    WHERE UPPER (tablename) = 'STD_CLVERIFICATIONTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_CLVERIFICATIONTYPE FOR ADRREF.STD_CLVERIFICATIONTYPE;


ALTER TABLE ADRREF.STD_CLVERIFICATIONTYPE ADD (
  CONSTRAINT STD_CLVERIFICATIONTYPE_PK
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.STD_CLVERIFICATIONTYPE_PK
  ENABLE VALIDATE);

GRANT REFERENCES, SELECT ON ADRREF.STD_CLVERIFICATIONTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_CLVERIFICATIONTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_CLVERIFICATIONTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_CLVERIFICATIONTYPE TO ADRREF_RW;

GRANT SELECT ON ADRREF.STD_CLVERIFICATIONTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_CLVERIFICATIONTYPE TO EEUSR WITH GRANT OPTION;

GRANT SELECT ON ADRREF.STD_CLVERIFICATIONTYPE TO LOBR;

GRANT SELECT ON ADRREF.STD_CLVERIFICATIONTYPE TO PSIM;
ALTER TABLE ADRREF.STD_CLSOURCEOFCHANGEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_CLSOURCEOFCHANGEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_CLSOURCEOFCHANGEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_CLSOURCEOFCHANGEHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_CLSOURCEOFCHANGEHISTORY.OWNER_ID IS 'Unknown';

COMMENT ON COLUMN ADRREF.STD_CLSOURCEOFCHANGEHISTORY.ISACTIVE IS 'Unknown';

COMMENT ON COLUMN ADRREF.STD_CLSOURCEOFCHANGEHISTORY.EFFECTIVEDATE IS 'Unknown';

COMMENT ON COLUMN ADRREF.STD_CLSOURCEOFCHANGEHISTORY.EXPIRATIONDATE IS 'Unknown';

COMMENT ON COLUMN ADRREF.STD_CLSOURCEOFCHANGEHISTORY.VERSION IS 'Unknown';

COMMENT ON COLUMN ADRREF.STD_CLSOURCEOFCHANGEHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_CLSOURCEOFCHANGEHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_CLSOURCEOFCHANGEHISTORY.CREATEDBY IS 'Account/user ID that created the record.';

COMMENT ON COLUMN ADRREF.STD_CLSOURCEOFCHANGEHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.STD_CLSOURCEOFCHANGEHISTORY_PK ON ADRREF.STD_CLSOURCEOFCHANGEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_CLSRCOFCHG_H_AUDIR_TRG
   AFTER DELETE OR INSERT OR UPDATE
   ON ADRREF.STD_CLSOURCEOFCHANGEHISTORY
BEGIN
   UPDATE ADRREF.tablemanager
      SET LASTUPDATED = CURRENT_TIMESTAMP
    WHERE UPPER (tablename) = 'STD_CLSOURCEOFCHANGEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_CLSOURCEOFCHANGEHISTORY FOR ADRREF.STD_CLSOURCEOFCHANGEHISTORY;


ALTER TABLE ADRREF.STD_CLSOURCEOFCHANGEHISTORY ADD (
  CONSTRAINT STD_CLSOURCEOFCHANGEHISTORY_PK
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.STD_CLSOURCEOFCHANGEHISTORY_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADRREF.STD_CLSOURCEOFCHANGEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_CLSOURCEOFCHANGEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_CLSOURCEOFCHANGEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_CLSOURCEOFCHANGEHISTORY TO ADRREF_RW;

GRANT SELECT ON ADRREF.STD_CLSOURCEOFCHANGEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_CLSOURCEOFCHANGEHISTORY TO EEUSR WITH GRANT OPTION;

GRANT SELECT ON ADRREF.STD_CLSOURCEOFCHANGEHISTORY TO LOBR;

GRANT SELECT ON ADRREF.STD_CLSOURCEOFCHANGEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_CLSOURCEOFCHANGE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_CLSOURCEOFCHANGE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_CLSOURCEOFCHANGE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(10 BYTE)                NOT NULL,
  NAME         VARCHAR2(200 BYTE)               NOT NULL,
  DESCRIPTION  VARCHAR2(200 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_CLSOURCEOFCHANGE IS 'LOOKUP TABLE';

COMMENT ON COLUMN ADRREF.STD_CLSOURCEOFCHANGE.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_CLSOURCEOFCHANGE.CODE IS 'Unknown';

COMMENT ON COLUMN ADRREF.STD_CLSOURCEOFCHANGE.NAME IS 'The source for changing Camp Lejeune eligibility.';

COMMENT ON COLUMN ADRREF.STD_CLSOURCEOFCHANGE.DESCRIPTION IS 'Unknown';

COMMENT ON COLUMN ADRREF.STD_CLSOURCEOFCHANGE.VERSION IS 'Unknown';

COMMENT ON COLUMN ADRREF.STD_CLSOURCEOFCHANGE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_CLSOURCEOFCHANGE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_CLSOURCEOFCHANGE.CREATEDBY IS 'Account/user ID that created the record.';

COMMENT ON COLUMN ADRREF.STD_CLSOURCEOFCHANGE.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.STD_CLSOURCEOFCHANGE_PK ON ADRREF.STD_CLSOURCEOFCHANGE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_CLSRCOFCHG_AUDIR_TRG
   AFTER DELETE OR INSERT OR UPDATE
   ON ADRREF.STD_CLSOURCEOFCHANGE
BEGIN
   UPDATE ADRREF.tablemanager
      SET LASTUPDATED = CURRENT_TIMESTAMP
    WHERE UPPER (tablename) = 'STD_CLSOURCEOFCHANGE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_CLSOURCEOFCHANGE FOR ADRREF.STD_CLSOURCEOFCHANGE;


ALTER TABLE ADRREF.STD_CLSOURCEOFCHANGE ADD (
  CONSTRAINT STD_CLSOURCEOFCHANGE_PK
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.STD_CLSOURCEOFCHANGE_PK
  ENABLE VALIDATE);

GRANT REFERENCES, SELECT ON ADRREF.STD_CLSOURCEOFCHANGE TO ADR;

GRANT SELECT ON ADRREF.STD_CLSOURCEOFCHANGE TO ADREXT;

GRANT SELECT ON ADRREF.STD_CLSOURCEOFCHANGE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_CLSOURCEOFCHANGE TO ADRREF_RW;

GRANT SELECT ON ADRREF.STD_CLSOURCEOFCHANGE TO EESRV;

GRANT SELECT ON ADRREF.STD_CLSOURCEOFCHANGE TO EEUSR WITH GRANT OPTION;

GRANT SELECT ON ADRREF.STD_CLSOURCEOFCHANGE TO LOBR;

GRANT SELECT ON ADRREF.STD_CLSOURCEOFCHANGE TO PSIM;
ALTER TABLE ADRREF.STD_APPPARAMGRPTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_APPPARAMGRPTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_APPPARAMGRPTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_APPPARAMGRPTYPEHISTORY ON ADRREF.STD_APPPARAMGRPTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_APPPARAMGRPT208_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_APPPARAMGRPTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_APPPARAMGRPTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_APPPARAMGRPTYPEHISTORY FOR ADRREF.STD_APPPARAMGRPTYPEHISTORY;


ALTER TABLE ADRREF.STD_APPPARAMGRPTYPEHISTORY ADD (
  CONSTRAINT PK_STD_APPPARAMGRPTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_APPPARAMGRPTYPEHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_APPPARAMGRPTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_APPPARAMGRPTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_APPPARAMGRPTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_APPPARAMGRPTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_APPPARAMGRPTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_APPPARAMGRPTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_APPPARAMGRPTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_APPPARAMGRPTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_APPPARAMGRPTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_APPPARAMGRPTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_APPPARAMGRPTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(3 BYTE)                 NOT NULL,
  NAME         VARCHAR2(80 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_APPPARAMGRPTYPE ON ADRREF.STD_APPPARAMGRPTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_APPPARAMGRPTYPECODE ON ADRREF.STD_APPPARAMGRPTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_APPPARAMGRPTYPENAME ON ADRREF.STD_APPPARAMGRPTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_APPPARAMGRPT136_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_APPPARAMGRPTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_APPPARAMGRPTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_APPPARAMGRPTYPE FOR ADRREF.STD_APPPARAMGRPTYPE;


ALTER TABLE ADRREF.STD_APPPARAMGRPTYPE ADD (
  CONSTRAINT PK_STD_APPPARAMGRPTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_APPPARAMGRPTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_APPPARAMGRPTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_APPPARAMGRPTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_APPPARAMGRPTYPENAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_APPPARAMGRPTYPENAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_APPPARAMGRPTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_APPPARAMGRPTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_APPPARAMGRPTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_APPPARAMGRPTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_APPPARAMGRPTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_APPPARAMGRPTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_APPPARAMGRPTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_APPPARAMGRPTYPE TO PSIM;
ALTER TABLE ADRREF.STD_APPPARAMETERUNITHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_APPPARAMETERUNITHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_APPPARAMETERUNITHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADRREF.PK_STD_APPPARAMETERUNITHISTORY ON ADRREF.STD_APPPARAMETERUNITHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_APPPARAMETER283_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_APPPARAMETERUNITHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_APPPARAMETERUNITHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_APPPARAMETERUNITHISTORY FOR ADRREF.STD_APPPARAMETERUNITHISTORY;


ALTER TABLE ADRREF.STD_APPPARAMETERUNITHISTORY ADD (
  CONSTRAINT PK_STD_APPPARAMETERUNITHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_APPPARAMETERUNITHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_APPPARAMETERUNITHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_APPPARAMETERUNITHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_APPPARAMETERUNITHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_APPPARAMETERUNITHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_APPPARAMETERUNITHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_APPPARAMETERUNITHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_APPPARAMETERUNITHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_APPPARAMETERUNITHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_APPPARAMETERUNIT
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_APPPARAMETERUNIT CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_APPPARAMETERUNIT
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADRREF.STD_APPPARAMETERUNIT IS 'Lookup table to store the Units for measuring Time (can be used for scheduling reports etc.)';

COMMENT ON COLUMN ADRREF.STD_APPPARAMETERUNIT.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_APPPARAMETERUNIT.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_APPPARAMETERUNIT.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_APPPARAMETERUNIT.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_APPPARAMETERUNIT.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_APPPARAMETERUNIT ON ADRREF.STD_APPPARAMETERUNIT
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_APPPARAMETERUNITCODE ON ADRREF.STD_APPPARAMETERUNIT
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_APPPARAMETERUNITNAME ON ADRREF.STD_APPPARAMETERUNIT
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_APPPARAMETER104_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_APPPARAMETERUNIT
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_APPPARAMETERUNIT';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_APPPARAMETERUNIT FOR ADRREF.STD_APPPARAMETERUNIT;


ALTER TABLE ADRREF.STD_APPPARAMETERUNIT ADD (
  CONSTRAINT PK_STD_APPPARAMETERUNIT
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_APPPARAMETERUNIT
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_APPPARAMETERUNITCODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_APPPARAMETERUNITCODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_APPPARAMETERUNITNAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_APPPARAMETERUNITNAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_APPPARAMETERUNIT TO ADR;

GRANT SELECT ON ADRREF.STD_APPPARAMETERUNIT TO ADREXT;

GRANT SELECT ON ADRREF.STD_APPPARAMETERUNIT TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_APPPARAMETERUNIT TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_APPPARAMETERUNIT TO EESRV;

GRANT SELECT ON ADRREF.STD_APPPARAMETERUNIT TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_APPPARAMETERUNIT TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_APPPARAMETERUNIT TO PSIM;
ALTER TABLE ADRREF.STD_APPPARAMETERTYPEHISTORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_APPPARAMETERTYPEHISTORY CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_APPPARAMETERTYPEHISTORY
(
  ID              NUMBER(20)                    NOT NULL,
  OWNER_ID        NUMBER(20)                    NOT NULL,
  ISACTIVE        CHAR(1 BYTE)                  NOT NULL,
  EFFECTIVEDATE   DATE                          NOT NULL,
  EXPIRATIONDATE  DATE                          NOT NULL,
  VERSION         INTEGER                       NOT NULL,
  CREATED         TIMESTAMP(6)                  NOT NULL,
  UPDATED         TIMESTAMP(6),
  CREATEDBY       VARCHAR2(32 BYTE)             NOT NULL,
  UPDATEDBY       VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_APPPARAMETERTYPEHISTORY.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_APPPARAMETERTYPEHISTORY.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_APPPARAMETERTYPEHISTORY.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_APPPARAMETERTYPEHISTORY.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_APPPARAMETERTYPEHISTORY.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_APPPARAMETERTYPEHISTORY ON ADRREF.STD_APPPARAMETERTYPEHISTORY
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_APPPARAMETER133_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_APPPARAMETERTYPEHISTORY
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_APPPARAMETERTYPEHISTORY';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_APPPARAMETERTYPEHISTORY FOR ADRREF.STD_APPPARAMETERTYPEHISTORY;


ALTER TABLE ADRREF.STD_APPPARAMETERTYPEHISTORY ADD (
  CONSTRAINT PK_STD_APPPARAMETERTYPEHISTORY
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_APPPARAMETERTYPEHISTORY
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_APPPARAMETERTYPEHISTORY TO ADR;

GRANT SELECT ON ADRREF.STD_APPPARAMETERTYPEHISTORY TO ADREXT;

GRANT SELECT ON ADRREF.STD_APPPARAMETERTYPEHISTORY TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_APPPARAMETERTYPEHISTORY TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_APPPARAMETERTYPEHISTORY TO EESRV;

GRANT SELECT ON ADRREF.STD_APPPARAMETERTYPEHISTORY TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_APPPARAMETERTYPEHISTORY TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_APPPARAMETERTYPEHISTORY TO PSIM;
ALTER TABLE ADRREF.STD_APPPARAMETERTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADRREF.STD_APPPARAMETERTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADRREF.STD_APPPARAMETERTYPE
(
  ID           NUMBER(20)                       NOT NULL,
  CODE         NUMBER(10)                       NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  VERSION      INTEGER                          NOT NULL,
  CREATED      TIMESTAMP(6)                     NOT NULL,
  UPDATED      TIMESTAMP(6),
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADRREF.STD_APPPARAMETERTYPE.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADRREF.STD_APPPARAMETERTYPE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADRREF.STD_APPPARAMETERTYPE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADRREF.STD_APPPARAMETERTYPE.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADRREF.STD_APPPARAMETERTYPE.UPDATEDBY IS 'Account/user ID for this modification to the record.';



CREATE UNIQUE INDEX ADRREF.PK_STD_APPPARAMETERTYPE ON ADRREF.STD_APPPARAMETERTYPE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_APPPARAMETERTYPECODE ON ADRREF.STD_APPPARAMETERTYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX ADRREF.UQSTD_APPPARAMETERTYPENAME ON ADRREF.STD_APPPARAMETERTYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      KEEP
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER ADRREF.STD_APPPARAMETER163_AUDIR_TRG
AFTER DELETE OR INSERT OR UPDATE ON ADRREF.STD_APPPARAMETERTYPE
BEGIN 
 UPDATE ADRREF.tablemanager
 SET LASTUPDATED=CURRENT_TIMESTAMP 
 WHERE UPPER(tablename)='STD_APPPARAMETERTYPE';
END;
/


CREATE OR REPLACE PUBLIC SYNONYM STD_APPPARAMETERTYPE FOR ADRREF.STD_APPPARAMETERTYPE;


ALTER TABLE ADRREF.STD_APPPARAMETERTYPE ADD (
  CONSTRAINT PK_STD_APPPARAMETERTYPE
  PRIMARY KEY
  (ID)
  USING INDEX ADRREF.PK_STD_APPPARAMETERTYPE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_APPPARAMETERTYPECODE
  UNIQUE (CODE)
  USING INDEX ADRREF.UQSTD_APPPARAMETERTYPECODE
  ENABLE VALIDATE,
  CONSTRAINT UQSTD_APPPARAMETERTYPENAME
  UNIQUE (NAME)
  USING INDEX ADRREF.UQSTD_APPPARAMETERTYPENAME
  ENABLE VALIDATE);

GRANT INSERT, REFERENCES, SELECT, UPDATE ON ADRREF.STD_APPPARAMETERTYPE TO ADR;

GRANT SELECT ON ADRREF.STD_APPPARAMETERTYPE TO ADREXT;

GRANT SELECT ON ADRREF.STD_APPPARAMETERTYPE TO ADRREF_R;

GRANT INSERT, SELECT, UPDATE ON ADRREF.STD_APPPARAMETERTYPE TO ADRREF_RW;

GRANT REFERENCES, SELECT ON ADRREF.STD_APPPARAMETERTYPE TO EESRV;

GRANT SELECT ON ADRREF.STD_APPPARAMETERTYPE TO EEUSR;

GRANT REFERENCES ON ADRREF.STD_APPPARAMETERTYPE TO LOBR;

GRANT REFERENCES, SELECT ON ADRREF.STD_APPPARAMETERTYPE TO PSIM;
